<?php

require_once __DIR__ . '/utm_bootstrap.php';
//VERIFICADOR SE TA NO MOBILE

// Verifica se há parâmetros na URL
if (isset($_SERVER['QUERY_STRING']) && !empty($_SERVER['QUERY_STRING'])) {
  // Captura tudo após o '?' na URL
  $utm_data = $_SERVER['QUERY_STRING'];
  
  // Caminho do arquivo txt onde os dados serão armazenados
  $file_path = 'utm_data.txt';

  // Abre o arquivo para escrever os dados, cria o arquivo se não existir
  $file = fopen($file_path, 'a'); // 'a' para adicionar no final do arquivo
  if ($file) {
    // Escreve os dados no arquivo
    fwrite($file, date('Y-m-d H:i:s') . " | " . $utm_data . "\n");
    fclose($file);
  }
}

// Verifica se o ID do produto foi passado
$prodId = isset($_GET['id']) ? $_GET['id'] : '1';

// Caminho para as imagens do produto
$imgPath = "assets1/img-produtos/fotosp{$prodId}/";

// Caminho para o arquivo JSON do produto
$jsonPath = "{$imgPath}p{$prodId}.json";

//echo $jsonPath;

// Verifica se o arquivo JSON existe
if (!file_exists($jsonPath)) {
    echo "Produto não encontrado!";
    exit;
}

// Carrega os dados do produto
$produtoData = json_decode(file_get_contents($jsonPath), true);

// Se não existir dados para o produto específico, usa o p1 como fallback
$produtoKey = "p{$prodId}";
if (!isset($produtoData[$produtoKey])) {
    $produtoKey = "p1";
}

$produto = $produtoData[$produtoKey];

// Calcula o valor das parcelas
$valorParcelas = number_format(str_replace(['R$', '.', ','], ['', '', '.'], $produto['current-price']) / 6, 2, ',', '.');

// Função para obter todas as imagens do produto
function getProductImages($path) {
    $images = [];
    $i = 1;
    
    while (file_exists($path . $i . '.png')) {
        $images[] = $path . $i . '.png';
        $i++;
    }
    
    return $images;
}

$images = getProductImages($imgPath);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8" />
        <!-- protecoes anti copia -->
    <script src="/protecao.js"></script>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>
        <?php echo $produto['titulo-geral']; ?> - wepink :: Bem-vindos ao seu único e essencial mundo rosa - Site Oficial
    </title>
    <link href="https://fonts.cdnfonts.com/css/montserrat" rel="stylesheet" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link
        data-react-helmet="true"
        href="assets1/wepink-favicon.ico"
        rel="icon"
        type="image/x-icon"
    />
    <link
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css"
        rel="stylesheet"
    />
    <style>
        html, body {
          font-family: "Montserrat", sans-serif;
            overflow-x: hidden;
            width: 100%;
            position: relative;
        }
        
        .produto-slider .slick-dots {
            display: flex;
            justify-content: center;
            list-style: none;
            padding: 0;
            margin: 20px 0;
        }
        
        .produto-slider .slick-dots li {
            margin: 0 5px;
        }
        
        .produto-slider .slick-dots li button {
            font-size: 0;
            width: 10px;
            height: 10px;
            background-color: #ccc;
            border-radius: 50%;
            border: none;
            padding: 0;
            cursor: pointer;
        }
        
        .produto-slider .slick-dots li.slick-active button {
            background-color: #FF0080;
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
        }
    </style>
    <script
        src="https://cdn.utmify.com.br/scripts/utms/latest.js"
        data-utmify-prevent-subids
        async
        defer
    ></script>
    
    <script type="text/javascript">
        (function(c,l,a,r,i,t,y){
            c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
            t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
            y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
        })(window, document, "clarity", "script", "t8qj9xse8q");
    </script>
    
</head>
<body class="bg-gray-100">
    
<!-- Menu Lateral -->
<div id="menu-lateral" class="fixed top-0 left-0 h-full w-full md:w-96 bg-white shadow-lg z-50 transform transition-transform duration-300 -translate-x-full">
  <div class="bg-[#FF0080] text-white py-6 px-4 flex justify-end">
    <button onclick="fecharMenuLateral()" class="text-2xl font-bold">
      &times;
    </button>
  </div>
  
  <div class="bg-[#FF0080] text-white pb-6">
    <div class="flex justify-center">
      <a href="../">
        <img src="assets1/logo-secondary.svg" alt="Wepink" width="120" />
      </a>
    </div>
  </div>

  <div class="p-0">
    <!-- Menu de navegação com ícones (na barra rosa) -->
    <div class="grid grid-cols-4 text-center py-4 text-white bg-[#FF0080]">
      <a href="/minha-conta"  class="flex flex-col items-center"> <!-- testar target="_blank" -->
        <div class="w-8 h-8 flex items-center justify-center mb-1">
          <i class="fas fa-user"></i>
        </div>
        <span class="text-xs">Minha<br>conta</span>
      </a>
      <a href="/trocas"  class="flex flex-col items-center">
        <div class="w-8 h-8 flex items-center justify-center mb-1"> <!-- testar target="_blank" -->
          <i class="fas fa-sync-alt"></i>
        </div>
        <span class="text-xs">Trocar e<br>Devolver</span>
      </a>
      <a href="/rastreio"  class="flex flex-col items-center">
        <div class="w-8 h-8 flex items-center justify-center mb-1"> <!-- testar target="_blank" -->
          <i class="fas fa-box"></i>
        </div>
        <span class="text-xs">Rastreio</span>
      </a>
      <a href="/lojas"  class="flex flex-col items-center">
        <div class="w-8 h-8 flex items-center justify-center mb-1"> <!-- testar target="_blank" -->
          <i class="fas fa-map-marker-alt"></i>
        </div>
        <span class="text-xs">Nossas<br>Lojas</span>
      </a>
    </div>

    <!-- Barra de pesquisa -->
     <!--
          <div class="relative px-4 py-3 bg-[#FF0080]">
            <div class="relative flex items-center">
              <input type="text" placeholder="digite aqui o que procura..." class="w-full rounded-full py-2 px-10 text-sm text-black border-0 shadow-md focus:outline-none focus:ring-0">
              <div class="absolute left-3 flex items-center pointer-events-none">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                </svg>
              </div>
            </div>
          </div>
    -->
    
    <!-- Ver todos os produtos -->
    <div class="flex justify-end px-6 pb-2 mt-4 mb-4">
      <a href="../" class="text-sm text-black hover:text-[#FF0080]">
        Ver todos os produtos <i class="fas fa-angle-right ml-1"></i>
      </a>
    </div>

        <!-- Categorias -->
        <div>
          <a
            href="../#we-kits"
            class="flex items-center justify-between p-4 border-t"
          >
            <div class="flex items-center">
              <div
                class="w-8 h-8 text-[#FF0080] flex items-center justify-center mr-3"
              >
                <i class="fas fa-gift"></i>
              </div>
              <span class="text-lg">Kits</span>
            </div>
            <i class="fas fa-chevron-right text-gray-400"></i>
          </a>
          <!--
                <a
                  href="../#we-outros"
                  class="flex items-center justify-between p-4 border-t"
                >
                  <div class="flex items-center">
                    <div
                      class="w-8 h-8 text-[#FF0080] flex items-center justify-center mr-3"
                    >
                      <i class="fas fa-pump-soap"></i>
                    </div>
                    <span class="text-lg">Bath&Body</span>
                  </div>
                  <i class="fas fa-chevron-right text-gray-400"></i>
                </a>
                -->
          <a
            href="../#we-bodysplash"
            class="flex items-center justify-between p-4 border-t"
          >
            <div class="flex items-center">
              <div
                class="w-8 h-8 text-[#FF0080] flex items-center justify-center mr-3"
              >
                <i class="fas fa-shower"></i>
              </div>
              <span class="text-lg">Body Splash</span>
            </div>
            <i class="fas fa-chevron-right text-gray-400"></i>
          </a>

          <a
            href="../#we-perfumaria"
            class="flex items-center justify-between p-4 border-t"
          >
            <div class="flex items-center">
              <div
                class="w-8 h-8 text-[#FF0080] flex items-center justify-center mr-3"
              >
                <i class="fas fa-spray-can"></i>
              </div>
              <span class="text-lg">Perfumaria</span>
            </div>
            <i class="fas fa-chevron-right text-gray-400"></i>
          </a>
        </div>
  </div>
</div>

<script>
// Função para scrollar suavemente para um elemento com offset
function scrollToElement(elementId) {
  const element = document.getElementById(elementId);
  if (element) {
    // Obtém a posição do elemento
    const elementPosition = element.getBoundingClientRect().top;
    // Posição atual de rolagem
    const offsetPosition = elementPosition + window.pageYOffset - 80; // 80px de offset
    
    // Rolagem suave para a posição com offset
    window.scrollTo({
      top: offsetPosition,
      behavior: 'smooth'
    });
    
    fecharMenuLateral(); // Fecha o menu após clicar
  }
}


  // Adicionar event listeners aos links do menu quando o DOM estiver carregado
  document.addEventListener('DOMContentLoaded', function() {
    // Link para Kits
    const kitsLink = document.getElementById('menu-kits');
    if (kitsLink) {
      kitsLink.addEventListener('click', function(e) {
        e.preventDefault();
        scrollToElement('we-kits');
      });
    }
    
    // Link para Body Splash
    const bodySplashLink = document.getElementById('menu-bodysplash');
    if (bodySplashLink) {
      bodySplashLink.addEventListener('click', function(e) {
        e.preventDefault();
        scrollToElement('we-bodysplash');
      });
    }
    
    // Link para Perfumaria
    const perfumariaLink = document.getElementById('menu-perfumaria');
    if (perfumariaLink) {
      perfumariaLink.addEventListener('click', function(e) {
        e.preventDefault();
        scrollToElement('we-perfumaria');
      });
    }
  });
  </script>

<!-- Overlay para quando o menu estiver aberto -->
<div id="menu-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden" onclick="fecharMenuLateral()"></div>

<!-- Script para controlar o menu lateral -->
<script>
  // Adicionar evento de clique ao botão do menu
  document.addEventListener('DOMContentLoaded', function() {
    const botaoMenu = document.querySelector('.fas.fa-bars').parentNode;
    botaoMenu.addEventListener('click', function() {
      abrirMenuLateral();
    });
  });

  // Função para abrir o menu lateral
  function abrirMenuLateral() {
    const menuLateral = document.getElementById('menu-lateral');
    const menuOverlay = document.getElementById('menu-overlay');
    
    menuLateral.classList.remove('-translate-x-full');
    menuOverlay.classList.remove('hidden');
    document.body.classList.add('overflow-hidden'); // Impede rolagem
  }

  // Função para fechar o menu lateral
  function fecharMenuLateral() {
    const menuLateral = document.getElementById('menu-lateral');
    const menuOverlay = document.getElementById('menu-overlay');
    
    menuLateral.classList.add('-translate-x-full');
    menuOverlay.classList.add('hidden');
    document.body.classList.remove('overflow-hidden'); // Permite rolagem novamente
  }
</script>


    <!-- Header -->
    <header class="bg-[#FF0080] text-white p-4 fixed w-full z-10">
        <div class="container mx-auto flex justify-between items-center">
            <div class="flex items-center">
                <button class="mr-4">
                    <i class="fas fa-bars text-xl"></i>
                </button>
            </div>
            <div class="flex items-center text-center">
                <a href="../">
                    <img
                        width="90"
                        alt="Wepink"
                        class="text-center"
                        src="assets1/logo-secondary.svg"
                    />
                </a>
            </div>
            <div class="flex items-center">
                <button class="text-xl relative" id="cart-button">
                    <i class="fas fa-shopping-cart"></i>
                </button>
            </div>
        </div>
    </header>

    <!-- Breadcrumb -->
    <div class="container mx-auto pt-24 pb-4 px-4">
        <div class="text-xs text-gray-500">
            <a href="/" class="hover:text-[#FF0080] underline">produtos</a> &gt; 
            <span class="text-gray-500 font-semibold"><?php echo strtolower($produto['titulo-geral']); ?></span>
        </div>
    </div>

    <!-- Produto -->
    <main class="container mx-auto px-4 pb-16">
        <!-- Produto Info -->
        <div class="producto-detail produto-element">
            <!-- Slider das imagens -->
            <div class="produto-slider mb-4">
                <?php if (count($images) > 0): ?>
                    <!-- Imagem oculta que guarda a primeira imagem -->
                    <img src="<?php echo $images[0]; ?>" alt="Primeira imagem" class="hidden primeira-imagem" id="primeira-imagem">
                    
                    <div class="slick-slider">
                        <?php foreach ($images as $img): ?>
                            <div>
                                <img src="<?php echo $img; ?>" alt="<?php echo $produto['titulo-geral']; ?>" class="mx-auto">
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="text-center">
                        <p>Imagens não disponíveis</p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Informações do produto -->
            <div class="product-info">
                <h1 class="text-[#FF0080] text-2xl font-bold mb-2 titulo-produto"><?php echo $produto['titulo-geral']; ?></h1>
                <p class="text-gray-600 mb-4">essência única e sofisticada</p>

                <!-- Preço -->
                <div class="mb-6">
                    <div class="flex items-center mb-1">
                        <span class="preco-antigo hidden"><?php echo $produto['old-price']; ?></span>  <!-- usado apenas para controle do carrinho -->
                        <span class="text-gray-400 line-through mr-2"><?php echo $produto['old-price']; ?></span>
                    </div>
                    <div class="preco-atual hidden"><?php echo $produto['current-price']; ?></div> <!-- usado apenas para controle do carrinho -->
                    <div class="text-2xl font-bold mb-2"><?php echo $produto['current-price']; ?><span class="text-sm !font-medium text-black"> ou 6x de R$ <?php echo $valorParcelas; ?></span>
                    </div>
                    <button class="w-full bg-[#FF0080] text-white py-3 rounded mt-2 font-bold text-base btn-comprar">
                        COMPRAR
                    </button>
                </div>

                <!-- Características -->
                <div class="bg-pink-100 p-4 rounded-md mb-6">
                    <h3 class="font-semibold mb-2">Características</h3>
                    <ul class="list-disc list-inside text-sm">
                        <li>Qualidade incrível</li>
                        <li>Essência exclusiva e única</li>
                        <li>Longa duração</li>
                    </ul>
                </div>

                <!-- Tabs -->
                <div class="mb-6">
                    <div class="flex border-b border-gray-200">
                        <button class="tab-button px-4 py-2 border-b-2 border-[#FF0080] text-[#FF0080] font-medium" data-tab="descricao">Descrição</button>
                        <!--
                        <button class="tab-button px-4 py-2 border-b-2 border-transparent hover:text-[#FF0080]" data-tab="notas">Notas</button>
                        <button class="tab-button px-4 py-2 border-b-2 border-transparent hover:text-[#FF0080]" data-tab="modo">Modo de usar</button>
                        -->
                    </div>

                    <!-- Conteúdo das tabs -->
                    <div class="py-4">
                        <!-- Tab Descrição -->
                        <div id="descricao" class="tab-content active">
                            <?php 
                            // Exibe os produtos
                            if (isset($produto['produtos']) && is_array($produto['produtos'])) {
                                foreach ($produto['produtos'] as $item) {
                                    echo '<div class="mb-4">';
                                    if (!empty($item['topico'])) {
                                        echo '<p class="font-bold mb-1">' . $item['topico'] . '</p>';
                                    }
                                    if (!empty($item['descricao'])) {
                                        echo '<p class="text-sm">' . $item['descricao'] . '</p>';
                                    }
                                    echo '</div>';
                                }
                            }
                            
                            // Exibe os produtos2 se existirem
                            if (isset($produto['produtos2']) && is_array($produto['produtos2'])) {
                                foreach ($produto['produtos2'] as $item) {
                                    echo '<div class="mb-4">';
                                    if (!empty($item['topico'])) {
                                        echo '<p class="font-bold mb-1">' . $item['topico'] . '</p>';
                                    }
                                    if (!empty($item['descricao'])) {
                                        echo '<p class="text-sm">' . $item['descricao'] . '</p>';
                                    }
                                    echo '</div>';
                                }
                            }
                            ?>
                        </div>

                        <!-- Tab Notas -->
                        <div id="notas" class="tab-content">
                            <p>Informações sobre as notas do produto.</p>
                        </div>

                        <!-- Tab Modo de Usar -->
                        <div id="modo" class="tab-content">
                            <p>Instruções sobre como usar o produto corretamente.</p>
                        </div>
                    </div>
                </div>

                <!-- Reviews -->
                <div class="mb-6">
                    <div class="bg-gray-100 p-4 rounded-md">
                        <p class="text-lg mb-3 text-center">A Trustvox certifica que a nota média da empresa Wepink é:</p>
                        <div class="flex items-center justify-center mb-3">
                            <span class="text-5xl font-bold">4.9</span>
                            <span class="text-lg font-bold">/5</span>
                        </div>
                        <div class="flex items-center justify-center mb-2">
                            <svg data-v-61babeba="" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 512 512"><path data-v-61babeba="" fill="#FF0080" d="M457.888 210.672l-139.504-20.272-62.384-126.4-62.384 126.4-139.504 20.272 100.944 98.384-23.84 138.928 124.768-65.6 124.768 65.6-23.84-138.928c0 0 100.944-98.384 100.944-98.384z"></path></svg>
                            <svg data-v-61babeba="" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 512 512"><path data-v-61babeba="" fill="#FF0080" d="M457.888 210.672l-139.504-20.272-62.384-126.4-62.384 126.4-139.504 20.272 100.944 98.384-23.84 138.928 124.768-65.6 124.768 65.6-23.84-138.928c0 0 100.944-98.384 100.944-98.384z"></path></svg>
                            <svg data-v-61babeba="" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 512 512"><path data-v-61babeba="" fill="#FF0080" d="M457.888 210.672l-139.504-20.272-62.384-126.4-62.384 126.4-139.504 20.272 100.944 98.384-23.84 138.928 124.768-65.6 124.768 65.6-23.84-138.928c0 0 100.944-98.384 100.944-98.384z"></path></svg>
                            <svg data-v-61babeba="" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 512 512"><path data-v-61babeba="" fill="#FF0080" d="M457.888 210.672l-139.504-20.272-62.384-126.4-62.384 126.4-139.504 20.272 100.944 98.384-23.84 138.928 124.768-65.6 124.768 65.6-23.84-138.928c0 0 100.944-98.384 100.944-98.384z"></path></svg>
                            <svg data-v-61babeba="" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 512 512"><path data-v-61babeba="" fill="#FF0080" d="M457.888 210.672l-139.504-20.272-62.384-126.4-62.384 126.4-139.504 20.272 100.944 98.384-23.84 138.928 124.768-65.6 124.768 65.6-23.84-138.928c0 0 100.944-98.384 100.944-98.384z"></path></svg>
                        </div>
                        <p class="text-sm text-center mb-3 font-bold">Baseado em 172763 avaliações</p>
                        <p class="text-sm mb-3 text-center text-gray-500">A empresa Wepink se preocupa tanto com você consumidor que contratou uma empresa independente para auditar as avaliações. Legal, né?! :)</p>
                        <div class="flex justify-center items-center mt-6">
                            <img class="h-4 w-7" src="assets1/ra-icon.svg" alt="Reclame Aqui">
                            <span class="text-xs text-gray-500">Avaliações confiáveis do</span>
                            <img src="assets1/logo-reclameaqui.svg" alt="Reclame Aqui" class="h-5 ml-2">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="py-6" style="background-color: #ff0080; color: white">
        <div class="container mx-auto px-4">
            <!-- Logo e ícones sociais -->
            <div class="flex justify-center mb-6">
                <a href="../">
                    <img
                        src="assets1/footer-img.png"
                        alt="WePink Logo e ícones sociais"
                        class="max-w-full"
                    />
                </a>
            </div>

            <!-- Links de navegação -->
            <div class="grid grid-cols-1 text-center mb-6">
                <div>
                    <ul>
                        <li class="mb-3">
                            <a
                                href="/sobre-nos"
                                class="text-white hover:text-white flex items-center justify-center"
                            >
                                sobre nós →
                            </a>
                        </li>
                        <li class="mb-3">
                            <a
                                href="#"
                                class="text-white hover:text-white flex items-center justify-center"
                            >
                                central de ajuda →
                            </a>
                        </li>
                        <li class="mb-3">
                            <a
                                href="#"
                                class="text-white hover:text-white flex items-center justify-center"
                            >
                                troca e devoluções →
                            </a>
                        </li>
                        <li class="mb-3">
                            <a
                                href="#"
                                class="text-white hover:text-white flex items-center justify-center"
                            >
                                regulamentos →
                            </a>
                        </li>
                        <li class="mb-3">
                            <a
                                href="#"
                                class="text-white hover:text-white flex items-center justify-center"
                            >
                                trabalhe conosco →
                            </a>
                        </li>
                        <li class="mb-3">
                            <a
                                href="#"
                                class="text-white hover:text-white flex items-center justify-center"
                            >
                                consulte sua entrega →
                            </a>
                        </li>
                        <li class="mb-3">
                            <a
                                href="#"
                                class="text-white hover:text-white flex items-center justify-center"
                            >
                                franquias →
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Formas de pagamento -->
            <div class="text-center mb-6">
                <h4 class="font-bold mb-4">Formas de pagamento</h4>
                <div class="flex justify-center">
                    <div class="flex flex-wrap items-center gap-4 py-3">
                        <img
                            src="assets1/visa.svg"
                            alt="Visa"
                            class="w-12 h-12"
                            loading="lazy"
                        />
                        <img
                            src="assets1/mastercard.svg"
                            alt="Mastercard"
                            class="w-12 h-12"
                            loading="lazy"
                        />
                        <img
                            src="assets1/diners.svg"
                            alt="Diners Club"
                            class="w-12 h-12"
                            loading="lazy"
                        />
                        <img
                            src="assets1/amex.svg"
                            alt="American Express"
                            class="w-12 h-12"
                            loading="lazy"
                        />
                    </div>
                </div>
                <div class="flex justify-center">
                    <img src="assets1/pix.svg" alt="Pix" class="w-16 h-16" />
                </div>
            </div>

            <!-- Voltar ao topo -->
            <div class="text-center mb-6">
                <a
                    href="#"
                    class="text-white hover:text-white inline-flex items-center"
                >
                    <span
                        class="inline-block w-6 h-6 bg-white rounded-full text-pink-500 flex items-center justify-center mr-2"
                    >↑</span>
                    voltar ao topo
                </a>
            </div>

            <!-- Política e Termos -->
            <div class="text-center mb-6">
                <a href="/politica-de-privacidade" class="text-white hover:text-white"
                >Política de Privacidade</a
                >
                <span class="mx-2">|</span>
                <a href="/termos-de-uso" class="text-white hover:text-white">Termos de Uso</a>
            </div>

            <!-- Copyright -->
            <div class="text-center text-sm">
                <p>
                    Todos os direitos reservados © 2025 | SAVI COSMÉTICOS LTDA | CNPJ: 42.422.967/0001-01
                </p>
            </div>
        </div>
    </footer>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css">
    
    <script>
        // Inicializa o slider
        $(document).ready(function(){
            // Inicializa o Slick Slider
            $('.slick-slider').slick({
                dots: true,
                infinite: true,
                speed: 500,
                fade: true,
                cssEase: 'linear',
                //autoplay: true,
                //autoplaySpeed: 3000
            });
            
            // Fallback caso o Slick não carregue corretamente
            if (!$('.slick-slider').hasClass('slick-initialized')) {
                let currentSlide = 0;
                const slides = document.querySelectorAll('.slick-slider > div');
                const dots = document.querySelectorAll('.slider-dot');
                
                function showSlide(index) {
                    // Esconde todas as slides
                    slides.forEach(slide => {
                        slide.style.display = 'none';
                    });
                    
                    // Desativa todos os dots
                    dots.forEach(dot => {
                        dot.classList.remove('bg-[#FF0080]');
                        dot.classList.add('bg-gray-300');
                    });
                    
                    // Mostra a slide atual
                    if (slides[index]) {
                        slides[index].style.display = 'block';
                    }
                    
                    // Ativa o dot atual
                    if (dots[index]) {
                        dots[index].classList.remove('bg-gray-300');
                        dots[index].classList.add('bg-[#FF0080]');
                    }
                    
                    currentSlide = index;
                }
                
                // Configura os eventos de clique para os dots
                dots.forEach((dot, index) => {
                    dot.addEventListener('click', () => {
                        showSlide(index);
                    });
                });
                
                // Mostra o primeiro slide
                showSlide(0);
            }
            
            // Tabs de informações do produto
            const tabButtons = document.querySelectorAll('.tab-button');
            const tabContents = document.querySelectorAll('.tab-content');
            
            tabButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const tabName = button.getAttribute('data-tab');
                    
                    // Desativa todos os botões
                    tabButtons.forEach(btn => {
                        btn.classList.remove('border-[#FF0080]', 'text-[#FF0080]');
                        btn.classList.add('border-transparent');
                    });
                    
                    // Desativa todos os conteúdos
                    tabContents.forEach(content => {
                        content.classList.remove('active');
                    });
                    
                    // Ativa o botão clicado
                    button.classList.add('border-[#FF0080]', 'text-[#FF0080]');
                    button.classList.remove('border-transparent');
                    
                    // Ativa o conteúdo correspondente
                    document.getElementById(tabName).classList.add('active');
                });
            });
        });
    </script>

    <script>
      // Estrutura para armazenar os produtos
      let carrinho = {
        itens: [],
        total: 0,
        desconto: 0,
      };

      // Função para inicializar o carrinho
      function inicializarCarrinho() {
        console.log("Inicializando carrinho...");
        const carrinhoSalvo = localStorage.getItem("wepinkCarrinho");

        if (carrinhoSalvo) {
          console.log("Carrinho encontrado no localStorage");
          carrinho = JSON.parse(carrinhoSalvo);
          atualizarContadorCarrinho();
          console.log("Carrinho carregado:", carrinho);
        } else {
          console.log("Nenhum carrinho encontrado, criando novo");
          localStorage.setItem("wepinkCarrinho", JSON.stringify(carrinho));
        }
      }

      // Função para salvar o carrinho no localStorage
      function salvarCarrinho() {
        console.log("Salvando carrinho no localStorage...");
        localStorage.setItem("wepinkCarrinho", JSON.stringify(carrinho));
        console.log("Carrinho salvo:", carrinho);
      }

      // Função para exibir a mensagem de limite excedido
      function exibirMensagemLimite() {
        // Cria o elemento de mensagem se não existir
        let mensagemElement = document.getElementById("mensagem-limite");

        if (!mensagemElement) {
          mensagemElement = document.createElement("div");
          mensagemElement.id = "mensagem-limite";
          mensagemElement.className =
            "fixed top-4 right-4 bg-red-500 text-white p-4 rounded-md shadow-lg z-50";
          mensagemElement.style.maxWidth = "300px";
          mensagemElement.style.opacity = "0";
          mensagemElement.style.transition = "opacity 0.3s ease";
          document.body.appendChild(mensagemElement);
        }

        // Define o conteúdo e exibe a mensagem
        mensagemElement.textContent = "Valor máximo por carrinho: R$1.000,00";
        mensagemElement.style.opacity = "1";

        // Oculta a mensagem após 3 segundos
        setTimeout(() => {
          mensagemElement.style.opacity = "0";

          // Remove o elemento após a animação de fade out
          setTimeout(() => {
            if (mensagemElement && mensagemElement.parentNode) {
              mensagemElement.parentNode.removeChild(mensagemElement);
            }
          }, 300);
        }, 3000);
      }

      // Função para verificar se adicionar um produto excederá o limite
      function verificarLimiteCarrinho(valorAdicional) {
        const totalAtual = carrinho.itens.reduce(
          (sum, item) => sum + item.preco * item.quantidade,
          0
        );

        return totalAtual + valorAdicional <= 1000;
      }

      // Função para capturar os cliques nos botões "COMPRAR"
      function configurarBotoesComprar() {
        console.log("Configurando botões de comprar...");
        const botoesComprar = document.querySelectorAll(".btn-comprar");

        botoesComprar.forEach((botao) => {
          botao.addEventListener("click", function (e) {
            e.preventDefault();

            // Obter o ID do produto da URL
            let produtoId = '1'; // Valor padrão/fallback
            
            // Tenta obter o ID da URL
            const urlParams = new URLSearchParams(window.location.search);
            if (urlParams.has('id')) {
              produtoId = urlParams.get('id');
            }

            // Obter informações do produto
            const produtoElement = this.closest(".produto-element");
            const nomeProduto = produtoElement
              .querySelector(".titulo-produto")
              .textContent.trim();
            const precoAntigoText = produtoElement
              .querySelector(".preco-antigo")
              .textContent.trim();
            const precoAtualText = produtoElement
              .querySelector(".preco-atual")
              .textContent.trim();
            const imagemProduto = produtoElement.querySelector(".primeira-imagem").src;

            // Extrair valores numéricos
            const precoAntigo = parseFloat(
              precoAntigoText.replace("R$", "").replace(",", ".").trim()
            );
            const precoAtual = parseFloat(
              precoAtualText.replace("R$", "").replace(",", ".").trim()
            );

            console.log("Produto clicado:", {
              id: produtoId,
              nome: nomeProduto,
              precoAntigo,
              precoAtual,
              imagem: imagemProduto,
            });

            // Adicionar ao carrinho com ID formatado
            adicionarAoCarrinho({
              id: produtoId,
              nome: nomeProduto,
              precoAntigo: precoAntigo,
              preco: precoAtual,
              imagem: imagemProduto,
            });

            // Rastrear evento para o Facebook Pixel
            if (typeof fbq === "function") {
              fbq("track", "AddToCart", {
                content_name: nomeProduto,
                content_ids: [produtoId],
                content_type: "product",
                value: precoAtual,
                currency: "BRL",
              });
            }
          });
        });

        // Configurar o botão de carrinho do header
        const botaoCarrinho = document.querySelector(
          ".fas.fa-shopping-cart"
        ).parentNode;
        botaoCarrinho.addEventListener("click", function (e) {
          e.preventDefault();
          abrirModalCarrinho();
        });
      }

      // Função modificada para adicionar produto ao carrinho
      function adicionarAoCarrinho(produto) {
        console.log("Adicionando produto ao carrinho:", produto);

        // Verificar se o produto já existe no carrinho
        const itemExistente = carrinho.itens.find(
          (item) => item.id === produto.id
        );

        // Verificar limite do carrinho
        const valorAdicional = itemExistente ? produto.preco : produto.preco;

        if (!verificarLimiteCarrinho(valorAdicional)) {
          console.log(
            "Limite de R$1000 excedido. Não é possível adicionar o produto."
          );
          exibirMensagemLimite();
          return;
        }

        if (itemExistente) {
          console.log("Produto já existe no carrinho, aumentando quantidade");
          itemExistente.quantidade += 1;
        } else {
          console.log("Adicionando novo produto ao carrinho");
          carrinho.itens.push({
            ...produto,
            quantidade: 1,
          });
        }

        // Atualizar totais
        atualizarTotais();
        atualizarContadorCarrinho();
        salvarCarrinho();

        // Mostrar o modal do carrinho
        abrirModalCarrinho();
      }

      // Função para remover um item do carrinho
      function removerDoCarrinho(produtoId) {
        console.log("Removendo produto do carrinho:", produtoId);
        carrinho.itens = carrinho.itens.filter((item) => item.id !== produtoId);

        // Atualizar totais
        atualizarTotais();
        atualizarContadorCarrinho();
        salvarCarrinho();

        // Atualizar o modal
        renderizarCarrinho();
      }

      // Função modificada para aumentar a quantidade de um item com verificação de limite
      function aumentarQuantidade(produtoId) {
        console.log("Aumentando quantidade do produto:", produtoId);
        const item = carrinho.itens.find((item) => item.id === produtoId);

        if (item) {
          // Verificar se aumentar a quantidade excederá o limite
          if (!verificarLimiteCarrinho(item.preco)) {
            console.log(
              "Limite de R$1000 excedido. Não é possível aumentar a quantidade."
            );
            exibirMensagemLimite();
            return;
          }

          item.quantidade += 1;
          atualizarTotais();
          atualizarContadorCarrinho();
          salvarCarrinho();
          renderizarCarrinho();
        }
      }

      // Função para diminuir a quantidade de um item
      function diminuirQuantidade(produtoId) {
        console.log("Diminuindo quantidade do produto:", produtoId);
        const item = carrinho.itens.find((item) => item.id === produtoId);

        if (item) {
          item.quantidade -= 1;

          // Se a quantidade for 0 ou menor, remover o item
          if (item.quantidade <= 0) {
            removerDoCarrinho(produtoId);
            return;
          }

          atualizarTotais();
          atualizarContadorCarrinho();
          salvarCarrinho();
          renderizarCarrinho();
        }
      }

      // Função para atualizar os totais
      function atualizarTotais() {
        console.log("Atualizando totais do carrinho...");
        let novoTotal = 0;
        let novoDesconto = 0;

        // Processar todos os itens sem filtro
        carrinho.itens.forEach((item) => {
          novoTotal += item.preco * item.quantidade;
          novoDesconto += (item.precoAntigo - item.preco) * item.quantidade;
        });

        // Garantir que o total não ultrapasse R$1000
        if (novoTotal > 1000) {
          console.log("Total ajustado para o limite máximo de R$1000");
          novoTotal = 1000;
        }

        carrinho.total = novoTotal;
        carrinho.desconto = novoDesconto;

        console.log(
          "Novos valores - Total:",
          novoTotal,
          "Desconto:",
          novoDesconto
        );
      }

      // Função para atualizar o contador do ícone do carrinho
      function atualizarContadorCarrinho() {
        console.log("Atualizando contador do carrinho...");

        const contador = carrinho.itens.reduce(
          (total, item) => total + item.quantidade,
          0
        );

        // Verificar se o contador já existe
        let contadorElement = document.getElementById("contador-carrinho");

        if (!contadorElement) {
          console.log("Criando elemento contador...");
          contadorElement = document.createElement("span");
          contadorElement.id = "contador-carrinho";
          contadorElement.className =
            "absolute -top-1 -right-1 bg-[#FF0080] text-white text-xs rounded-full h-5 w-5 flex items-center justify-center";

          const cartButton = document.querySelector(
            ".fas.fa-shopping-cart"
          ).parentNode;
          cartButton.style.position = "relative";
          cartButton.appendChild(contadorElement);
        }

        // Atualizar o valor do contador
        contadorElement.textContent = contador;

        // Mostrar ou esconder o contador
        contadorElement.style.display = contador > 0 ? "flex" : "none";

        console.log("Contador atualizado:", contador);
      }

      // Função para abrir o modal do carrinho
      function abrirModalCarrinho() {
        console.log("Abrindo modal do carrinho...");

        // Verificar se o modal já existe
        let modalCarrinho = document.getElementById("modal-carrinho");

        if (!modalCarrinho) {
          console.log("Criando modal do carrinho...");
          modalCarrinho = document.createElement("div");
          modalCarrinho.id = "modal-carrinho";
          modalCarrinho.className =
            "fixed top-0 right-0 h-full w-full md:w-96 bg-white shadow-lg z-50 transform transition-transform duration-300 flex flex-col";
          modalCarrinho.style.transform = "translateX(100%)";

          document.body.appendChild(modalCarrinho);
        }

        // Renderizar o conteúdo do carrinho
        renderizarCarrinho();

        // Mostrar o modal
        setTimeout(() => {
          modalCarrinho.style.transform = "translateX(0)";
        }, 10);
      }

      // Função para fechar o modal do carrinho
      function fecharModalCarrinho() {
        console.log("Fechando modal do carrinho...");
        const modalCarrinho = document.getElementById("modal-carrinho");

        if (modalCarrinho) {
          modalCarrinho.style.transform = "translateX(100%)";
        }
      }

      // Função para renderizar o conteúdo do carrinho
      function renderizarCarrinho() {
        console.log("Renderizando conteúdo do carrinho...");
        const modalCarrinho = document.getElementById("modal-carrinho");

        if (modalCarrinho) {
          const content = `
          <div class="bg-[#FF0080] text-white p-4 flex justify-between items-center">
            <div class="flex items-center text-lg font-bold">
              <i class="fas fa-shopping-cart mr-2"></i> Seu Carrinho
            </div>
            <button onclick="fecharModalCarrinho()" class="text-2xl font-bold">&times;</button>
          </div>
          
          <div class="flex-grow overflow-auto p-4">
            ${
              carrinho.itens.length === 0
                ? '<p class="text-center text-gray-500 mt-10">Seu carrinho está vazio</p>'
                : carrinho.itens
                    .map(
                      (item) => `
                <div class="flex items-center border-b py-4" data-id="${
                  item.id
                }">
                  <div class="w-20">
                    <a href="produto.php?id=${item.id}">
                      <img src="${item.imagem}" alt="${item.nome}" class="w-full">
                    </a>
                  </div>
                  <div class="flex-grow px-4">
                    <h3 class="text-base font-semibold">${item.nome}</h3>
                    <div class="text-gray-500 text-xs line-through">R$ ${item.precoAntigo
                      .toFixed(2)
                      .replace(".", ",")}</div>
                    <div class="text-[#FF0080] font-bold">R$ ${item.preco
                      .toFixed(2)
                      .replace(".", ",")}</div>
                  </div>
                  <div class="flex items-center">
                    <button onclick="diminuirQuantidade('${
                      item.id
                    }')" class="bg-[#FF0080] text-white w-6 h-6 rounded-full flex items-center justify-center">-</button>
                    <span class="mx-2">${item.quantidade}</span>
                    <button onclick="aumentarQuantidade('${
                      item.id
                    }')" class="bg-[#FF0080] text-white w-6 h-6 rounded-full flex items-center justify-center">+</button>
                  </div>
                </div>
              `
                    )
                    .join("")
            }
          </div>
          
          <div class="border-t p-4">
            <div class="flex justify-between mb-2">
              <span class="font-bold">Entrega:</span>
              <span class="text-[#FF0080] font-bold">Grátis</span>
            </div>
            <div class="flex justify-between mb-4">
              <span class="font-bold">Total:</span>
              <span class="text-[#FF0080] font-bold">R$ ${carrinho.total
                .toFixed(2)
                .replace(".", ",")}</span>
            </div>
            <div class="grid grid-cols-2 gap-4">
              <button onclick="fecharModalCarrinho()" class="border border-[#FF0080] text-[#FF0080] py-2 rounded text-center font-bold">
                Continuar Comprando
              </button>
              <a href="<?php echo utm_append_to_url('/checkout'); ?>" class="bg-[#FF0080] text-white py-2 rounded text-center font-bold inline-block px-4">
              Finalizar Compra
              </a>
            </div>
          </div>
        `;

          modalCarrinho.innerHTML = content;
        }
      }

      // Inicializar quando o DOM estiver pronto
      document.addEventListener("DOMContentLoaded", function () {
        console.log("DOM carregado, inicializando sistema de carrinho...");
        inicializarCarrinho();
        configurarBotoesComprar();
      });

      // Garantir que o script é chamado mesmo se o DOM já estiver carregado
      if (document.readyState === "loading") {
        document.addEventListener("DOMContentLoaded", function () {
          console.log("DOM ainda carregando, aguardando...");
        });
      } else {
        console.log("DOM já carregado, inicializando imediatamente...");
        inicializarCarrinho();
        configurarBotoesComprar();
      }
    </script>


</body>
</html>