<?php
// Função para obter o IP real do usuário
function obterIPReal() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ips = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        return trim($ips[0]);
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED'])) {
        return $_SERVER['HTTP_X_FORWARDED'];
    } elseif (!empty($_SERVER['HTTP_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_FORWARDED_FOR'];
    } elseif (!empty($_SERVER['HTTP_FORWARDED'])) {
        return $_SERVER['HTTP_FORWARDED'];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

// Captura os dados automaticamente
$ip = obterIPReal();
$userAgent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'User Agent não disponível';
$dataHora = date('Y-m-d H:i:s');
$referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : 'Acesso direto';
$paginaAcessada = $_SERVER['REQUEST_URI'];

// Formata os dados para salvar
$dadosParaSalvar = "=== NOVO ACESSO ===" . PHP_EOL;
$dadosParaSalvar .= "Data/Hora: " . $dataHora . PHP_EOL;
$dadosParaSalvar .= "IP: " . $ip . PHP_EOL;
$dadosParaSalvar .= "User Agent: " . $userAgent . PHP_EOL;
$dadosParaSalvar .= "Página Acessada: " . $paginaAcessada . PHP_EOL;
$dadosParaSalvar .= "Referrer: " . $referer . PHP_EOL;
$dadosParaSalvar .= "====================" . PHP_EOL . PHP_EOL;

// Salva no arquivo
$arquivo = 'dados_salvos.txt';
$salvou = file_put_contents($arquivo, $dadosParaSalvar, FILE_APPEND | LOCK_EX);

// Opcional: Exibir uma mensagem simples ou redirecionar
if ($salvou) {
    echo "Dados capturados com sucesso!";
    // Ou você pode redirecionar para outra página:
    // header('Location: https://www.google.com');
    // exit;
} else {
    echo "Erro ao salvar dados.";
}
?>