<?php

require_once __DIR__ . '/../utm_bootstrap.php';
//VERIFICADOR SE TA NO MOBILE

// Verifica se há parâmetros na URL
if (isset($_SERVER['QUERY_STRING']) && !empty($_SERVER['QUERY_STRING'])) {
  // Captura tudo após o '?' na URL
  $utm_data = $_SERVER['QUERY_STRING'];
  
  // Caminho do arquivo txt onde os dados serão armazenados
  $file_path = 'utm_data.txt';

  // Abre o arquivo para escrever os dados, cria o arquivo se não existir
  $file = fopen($file_path, 'a'); // 'a' para adicionar no final do arquivo
  if ($file) {
    // Escreve os dados no arquivo
    fwrite($file, date('Y-m-d H:i:s') . " | " . $utm_data . "\n");
    fclose($file);
  }
}

?>
<!DOCTYPE html>
<html lang="pt-BR">
  <head>
    <meta charset="UTF-8" />

    <!-- Meta Pixel Code -->
    <script>
      !(function (f, b, e, v, n, t, s) {
        if (f.fbq) return;
        n = f.fbq = function () {
          n.callMethod
            ? n.callMethod.apply(n, arguments)
            : n.queue.push(arguments);
        };
        if (!f._fbq) f._fbq = n;
        n.push = n;
        n.loaded = !0;
        n.version = "2.0";
        n.queue = [];
        t = b.createElement(e);
        t.async = !0;
        t.src = v;
        s = b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t, s);
      })(
        window,
        document,
        "script",
        "https://connect.facebook.net/en_US/fbevents.js"
      );
      fbq("init", "806911238441130");
      fbq("track", "PageView");
    </script>
    <noscript
      ><img
        height="1"
        width="1"
        style="display: none"
        src="https://www.facebook.com/tr?id=806911238441130&ev=PageView&noscript=1"
    /></noscript>
    <!-- End Meta Pixel Code -->

    <script
      src="https://cdn.utmify.com.br/scripts/utms/latest.js"
      data-utmify-prevent-subids
      async
      defer
    ></script>
    
    <!-- protecoes anti copia -->
    <script src="/protecao.js"></script>

    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>
      wepink :: Bem-vindos ao seu único e essencial mundo rosa - Site Oficial
    </title>
    <link href="https://fonts.cdnfonts.com/css/montserrat" rel="stylesheet" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link
      data-react-helmet="true"
      href="../assets1/wepink-favicon.ico"
      rel="icon"
      type="image/x-icon"
    />
    <link
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css"
      rel="stylesheet"
    />
    <style>
      html,
      body {
        font-family: "Montserrat", sans-serif;
      }
    </style>
    <script
      src="https://cdn.utmify.com.br/scripts/utms/latest.js"
      data-utmify-prevent-subids
      async
      defer
    ></script>
  </head>
  <body class="bg-gray-100">
    <!-- Menu Lateral -->
    <div
      id="menu-lateral"
      class="fixed top-0 left-0 h-full w-full md:w-96 bg-white shadow-lg z-50 transform transition-transform duration-300 -translate-x-full"
    >
      <div class="bg-[#FF0080] text-white py-6 px-4 flex justify-end">
        <button onclick="fecharMenuLateral()" class="text-2xl font-bold">
          &times;
        </button>
      </div>

      <div class="bg-[#FF0080] text-white pb-6">
        <div class="flex justify-center">
          <a href="../">
            <img src="../assets1/logo-secondary.svg" alt="Wepink" width="120" />
          </a>
        </div>
      </div>

      <div class="p-0">
        <!-- Menu de navegação com ícones (na barra rosa) -->
        <div class="grid grid-cols-4 text-center py-4 text-white bg-[#FF0080]">
          <a href="/minha-conta" class="flex flex-col items-center">
            <!-- testar target="_blank" -->
            <div class="w-8 h-8 flex items-center justify-center mb-1">
              <i class="fas fa-user"></i>
            </div>
            <span class="text-xs">Minha<br />conta</span>
          </a>
          <a href="/trocas" class="flex flex-col items-center">
            <div class="w-8 h-8 flex items-center justify-center mb-1">
              <!-- testar target="_blank" -->
              <i class="fas fa-sync-alt"></i>
            </div>
            <span class="text-xs">Trocar e<br />Devolver</span>
          </a>
          <a href="/rastreio" class="flex flex-col items-center">
            <div class="w-8 h-8 flex items-center justify-center mb-1">
              <!-- testar target="_blank" -->
              <i class="fas fa-box"></i>
            </div>
            <span class="text-xs">Rastreio</span>
          </a>
          <a href="/lojas" class="flex flex-col items-center">
            <div class="w-8 h-8 flex items-center justify-center mb-1">
              <!-- testar target="_blank" -->
              <i class="fas fa-map-marker-alt"></i>
            </div>
            <span class="text-xs">Nossas<br />Lojas</span>
          </a>
        </div>

        <!-- Barra de pesquisa -->
        <!--
                  <div class="relative px-4 py-3 bg-[#FF0080]">
                    <div class="relative flex items-center">
                      <input type="text" placeholder="digite aqui o que procura..." class="w-full rounded-full py-2 px-10 text-sm text-black border-0 shadow-md focus:outline-none focus:ring-0">
                      <div class="absolute left-3 flex items-center pointer-events-none">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                        </svg>
                      </div>
                    </div>
                  </div>
            -->

        <!-- Ver todos os produtos -->
        <div class="flex justify-end px-6 pb-2 mt-4 mb-4">
          <a href="../" class="text-sm text-black hover:text-[#FF0080]">
            Ver todos os produtos <i class="fas fa-angle-right ml-1"></i>
          </a>
        </div>

        <!-- Categorias -->
        <div>
          <a
            href="../#we-kits"
            class="flex items-center justify-between p-4 border-t"
          >
            <div class="flex items-center">
              <div
                class="w-8 h-8 text-[#FF0080] flex items-center justify-center mr-3"
              >
                <i class="fas fa-gift"></i>
              </div>
              <span class="text-lg">Kits</span>
            </div>
            <i class="fas fa-chevron-right text-gray-400"></i>
          </a>
          <!--
          <a
            href="../#we-outros"
            class="flex items-center justify-between p-4 border-t"
          >
            <div class="flex items-center">
              <div
                class="w-8 h-8 text-[#FF0080] flex items-center justify-center mr-3"
              >
                <i class="fas fa-pump-soap"></i>
              </div>
              <span class="text-lg">Bath&Body</span>
            </div>
            <i class="fas fa-chevron-right text-gray-400"></i>
          </a>
          -->
          <a
            href="../#we-bodysplash"
            class="flex items-center justify-between p-4 border-t"
          >
            <div class="flex items-center">
              <div
                class="w-8 h-8 text-[#FF0080] flex items-center justify-center mr-3"
              >
                <i class="fas fa-shower"></i>
              </div>
              <span class="text-lg">Body Splash</span>
            </div>
            <i class="fas fa-chevron-right text-gray-400"></i>
          </a>

          <a
            href="../#we-perfumaria"
            class="flex items-center justify-between p-4 border-t"
          >
            <div class="flex items-center">
              <div
                class="w-8 h-8 text-[#FF0080] flex items-center justify-center mr-3"
              >
                <i class="fas fa-spray-can"></i>
              </div>
              <span class="text-lg">Perfumaria</span>
            </div>
            <i class="fas fa-chevron-right text-gray-400"></i>
          </a>
        </div>
      </div>
    </div>

    <!-- Overlay para quando o menu estiver aberto -->
    <div
      id="menu-overlay"
      class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden"
      onclick="fecharMenuLateral()"
    ></div>

    <!-- Script para controlar o menu lateral -->
    <script>
      // Adicionar evento de clique ao botão do menu
      document.addEventListener("DOMContentLoaded", function () {
        const botaoMenu = document.querySelector(".fas.fa-bars").parentNode;
        botaoMenu.addEventListener("click", function () {
          abrirMenuLateral();
        });
      });

      // Função para abrir o menu lateral
      function abrirMenuLateral() {
        const menuLateral = document.getElementById("menu-lateral");
        const menuOverlay = document.getElementById("menu-overlay");

        menuLateral.classList.remove("-translate-x-full");
        menuOverlay.classList.remove("hidden");
        document.body.classList.add("overflow-hidden"); // Impede rolagem
      }

      // Função para fechar o menu lateral
      function fecharMenuLateral() {
        const menuLateral = document.getElementById("menu-lateral");
        const menuOverlay = document.getElementById("menu-overlay");

        menuLateral.classList.add("-translate-x-full");
        menuOverlay.classList.add("hidden");
        document.body.classList.remove("overflow-hidden"); // Permite rolagem novamente
      }
    </script>

    <!-- Header -->
    <header class="bg-[#FF0080] text-white p-4 fixed w-full z-10">
      <div class="container mx-auto flex justify-between items-center">
        <div class="flex items-center">
          <button class="mr-4">
            <i class="fas fa-bars text-xl"></i>
          </button>
        </div>
        <div class="flex items-center text-center">
          <a href="../">
            <img
              width="90"
              alt="Wepink"
              class="text-center"
              src="../assets1/logo-secondary.svg"
            />
          </a>
        </div>
        <div class="flex items-center">
          <button class="text-xl relative" id="cart-button">
            <i class="fas fa-shopping-cart"></i>
          </button>
        </div>
      </div>
    </header>

    <main class="pt-24 pb-8">
      <!-- Título e Campo de Busca -->
      <div class="container mx-auto px-4 mb-12">
        <h1 class="text-[#FF0080] text-4xl font-bold text-center mb-4">
          Lojas <span class="text-[#FF0080]">wepink</span>
        </h1>

        <div class="bg-gray-100 p-8 rounded-lg text-center mb-9">
          <h2 class="text-xl mb-4">
            Conheça todos os pontos físicos da nossa rede, onde você encontra o
            mesmo padrão de qualidade, atendimento e variedade que tornaram
            nossa marca referência no mercado.
          </h2>
          <!--
          <div class="flex justify-center">
            <div class="relative w-full max-w-md">
              <input
                type="text"
                placeholder="Busque pelo CEP"
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none"
              />
              <button
                class="absolute right-0 top-0 bottom-0 bg-[#FF0080] text-white px-4 rounded-r-lg"
              >
                →
              </button>
            </div>
          </div>
          -->
        </div>

        <!-- Seção Nossas Lojas -->
        <div class="mb-8">
          <h2 class="text-2xl font-bold text-[#FF0080] mb-6">Nossas Lojas</h2>

          <!-- Abas dos Estados -->
          <div class="overflow-x-auto mb-6">
            <div class="flex border-b border-gray-200 min-w-max">
              <button
                class="state-tab px-4 py-2 font-medium text-gray-700 hover:text-[#FF0080] focus:outline-none"
                data-state="alagoas"
              >
                <i class="fas fa-map-marker-alt mr-2 text-[#FF0080]"></i>
                Alagoas
              </button>
              <button
                class="state-tab px-4 py-2 font-medium text-gray-700 hover:text-[#FF0080] focus:outline-none"
                data-state="bahia"
              >
                <i class="fas fa-map-marker-alt mr-2"></i> Bahia
              </button>
              <button
                class="state-tab px-4 py-2 font-medium text-gray-700 hover:text-[#FF0080] focus:outline-none"
                data-state="brasilia"
              >
                <i class="fas fa-map-marker-alt mr-2"></i> Brasília
              </button>
              <button
                class="state-tab px-4 py-2 font-medium text-gray-700 hover:text-[#FF0080] focus:outline-none"
                data-state="ceara"
              >
                <i class="fas fa-map-marker-alt mr-2"></i> Ceará
              </button>
              <button
                class="state-tab px-4 py-2 font-medium text-gray-700 hover:text-[#FF0080] focus:outline-none"
                data-state="distrito-federal"
              >
                <i class="fas fa-map-marker-alt mr-2"></i> Distrito Federal
              </button>
              <button
                class="state-tab px-4 py-2 font-medium text-gray-700 hover:text-[#FF0080] focus:outline-none"
                data-state="espirito-santo"
              >
                <i class="fas fa-map-marker-alt mr-2"></i> Espírito Santo
              </button>
              <button
                class="state-tab px-4 py-2 font-medium text-gray-700 hover:text-[#FF0080] focus:outline-none"
                data-state="goias"
              >
                <i class="fas fa-map-marker-alt mr-2"></i> Goiás
              </button>
              <button
                class="state-tab px-4 py-2 font-medium text-gray-700 hover:text-[#FF0080] focus:outline-none"
                data-state="maranhao"
              >
                <i class="fas fa-map-marker-alt mr-2"></i> Maranhão
              </button>
              <button
                class="state-tab px-4 py-2 font-medium text-gray-700 hover:text-[#FF0080] focus:outline-none"
                data-state="mato-grosso"
              >
                <i class="fas fa-map-marker-alt mr-2"></i> Mato Grosso
              </button>
            </div>
          </div>

          <!-- Indicador de Aba Ativa -->
          <div class="relative">
            <div
              class="active-indicator absolute h-1 bg-[#FF0080] transition-all duration-300"
              style="width: 80px; left: 0"
            ></div>
          </div>

          <!-- Conteúdo dos Estados - Alagoas (visível por padrão) -->
          <div class="state-content" id="alagoas-content">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mt-8">
              <!-- Loja Maceió Shopping -->
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Maceió Shopping</h3>
                  <span
                    class="bg-[#FF0080] text-white text-xs px-3 py-1 rounded-full"
                    >Loja nova!</span
                  >
                </div>
                <p class="text-gray-700 mb-4">
                  Av. Comendador Gustavo Paiva, 2990 - 1º piso, Maceió -
                  Mangabeiras
                </p>
              </div>
            </div>
          </div>

          <!-- Conteúdo dos Estados - Bahia (oculto por padrão) -->
          <div class="state-content hidden" id="bahia-content">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mt-8">
              <!-- Shopping Boulevard Feira de Santana -->
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">
                    Shopping Boulevard Feira de Santana
                  </h3>
                  <span
                    class="bg-[#FF0080] text-white text-xs px-3 py-1 rounded-full"
                    >Loja nova!</span
                  >
                </div>
                <p class="text-gray-700 mb-4">
                  Av João Durval Carneiro, 3665 - Piso Térreo - Caseb, Feira de
                  Santana
                </p>
              </div>

              <!-- Shopping da Bahia -->
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Shopping da Bahia</h3>
                </div>
                <p class="text-gray-700 mb-4">
                  Av. Tancredo Neves, 148 - 3º piso - Caminho das Árvores,
                  Salvador
                </p>
              </div>
            </div>
          </div>

          <!-- Conteúdo dos Estados - Brasília (oculto por padrão) -->
          <div class="state-content hidden" id="brasilia-content">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mt-8">
              <!-- Shopping Conjunto Nacional -->
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Shopping Conjunto Nacional</h3>
                  <span
                    class="bg-[#FF0080] text-white text-xs px-3 py-1 rounded-full"
                    >Loja nova!</span
                  >
                </div>
                <p class="text-gray-700 mb-4">
                  SDN, CNB - Asa Norte, Brasília - DF, - Piso 1 - Asa Norte,
                  Brasília, Brasília
                </p>
              </div>
            </div>
          </div>

          <!-- Conteúdo dos Estados - Ceará (oculto por padrão) -->
          <div class="state-content hidden" id="ceara-content">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mt-8">
              <!-- Shopping RioMar Fortaleza -->
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Shopping RioMar Fortaleza</h3>
                  <span
                    class="bg-[#FF0080] text-white text-xs px-3 py-1 rounded-full"
                    >Loja nova!</span
                  >
                </div>
                <p class="text-gray-700 mb-4">
                  R. Des. Lauro Nogueira, 1500 - Piso L1 - Papicu, Fortaleza
                </p>
              </div>

              <!-- Shopping Iguatemi Bosque -->
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Shopping Iguatemi Bosque</h3>
                  <span
                    class="bg-[#FF0080] text-white text-xs px-3 py-1 rounded-full"
                    >Loja nova!</span
                  >
                </div>
                <p class="text-gray-700 mb-4">
                  Av Washington Soares, 85 - Edson Queiroz - Piso L1, Fortaleza
                </p>
              </div>
            </div>
          </div>

          <!-- Conteúdo dos Estados - Distrito Federal (oculto por padrão) -->
          <div class="state-content hidden" id="distrito-federal-content">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mt-8">
              <!-- ParkShopping -->
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">ParkShopping</h3>
                </div>
                <p class="text-gray-700 mb-4">
                  SMAS Trecho 1 - Guará, Brasília - Piso 2 - Guará | Brasília -
                  DF, Brasília
                </p>
              </div>
            </div>
          </div>

          <!-- Conteúdo dos Estados - Espírito Santo (oculto por padrão) -->
          <div class="state-content hidden" id="espirito-santo-content">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mt-8">
              <!-- Shopping Vitória -->
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Shopping Vitória</h3>
                  <span
                    class="bg-[#FF0080] text-white text-xs px-3 py-1 rounded-full"
                    >Loja nova!</span
                  >
                </div>
                <p class="text-gray-700 mb-4">
                  Av. Américo Buaiz, 200 - Enseada do Suá - 1º Piso, Vitória
                </p>
              </div>

              <!-- Shopping Moxuara -->
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Shopping Moxuara</h3>
                  <span
                    class="bg-[#FF0080] text-white text-xs px-3 py-1 rounded-full"
                    >Loja nova!</span
                  >
                </div>
                <p class="text-gray-700 mb-4">
                  Av. Mário Gurgel, 5353 - São Francisco - Piso L2, Cariacica
                </p>
              </div>

              <!-- Shopping Vilha Velha -->
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Shopping Vilha Velha</h3>
                  <span
                    class="bg-[#FF0080] text-white text-xs px-3 py-1 rounded-full"
                    >Loja nova!</span
                  >
                </div>
                <p class="text-gray-700 mb-4">
                  Av. Luciano das Neves 2418 Centro - Piso L/1, Vilha Velha
                </p>
              </div>
            </div>
          </div>

          <!-- Conteúdo dos Estados - Goiás (oculto por padrão) -->
          <div class="state-content hidden" id="goias-content">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mt-8">
              <!-- Shopping Flamboyant -->
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Shopping Flamboyant</h3>
                </div>
                <p class="text-gray-700 mb-4">
                  Av. Deputado Jamel Cecílio, 3300 - Piso 1 - Jardim Goiás,
                  Goiânia - GO
                </p>
              </div>

              <!-- Araguaia Shopping -->
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Araguaia Shopping</h3>
                  <span
                    class="bg-[#FF0080] text-white text-xs px-3 py-1 rounded-full"
                    >Loja nova!</span
                  >
                </div>
                <p class="text-gray-700 mb-4">Rua 44, nº 399 - Piso 1</p>
              </div>
            </div>
          </div>

          <!-- Conteúdo dos Estados - Maranhao -->
          <div class="state-content hidden" id="maranhao-content">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mt-8">
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Shopping da Ilha</h3>
                  <span
                    class="bg-[#FF0080] text-white text-xs px-3 py-1 rounded-full"
                    >Loja nova!</span
                  >
                </div>
                <p class="text-gray-700 mb-4">
                  Av. Daniel de La Touche, 987 - Piso L3 - Cohama, São Luís
                </p>
              </div>

              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Imperial Shopping</h3>
                  <span
                    class="bg-[#FF0080] text-white text-xs px-3 py-1 rounded-full"
                    >Loja nova!</span
                  >
                </div>
                <p class="text-gray-700 mb-4">
                  Marginal BR-010, 100 - 1º Piso - Jardim Sao Luis, Imperatriz -
                  Piso 1 - Jardim Sao Luis, Imperatriz, Imperatriz
                </p>
              </div>
            </div>
          </div>

          <!-- Conteúdo dos Estados - Mato Grosso -->
          <div class="state-content hidden" id="mato-grosso-content">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mt-8">
              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Shopping Estação Cuiabá</h3>
                </div>
                <p class="text-gray-700 mb-4">
                  Av. Miguel Sutil, 9300 - Piso L1 - Santa Rosa, Cuiabá - MT
                </p>
              </div>

              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Pantanal Shopping</h3>
                </div>
                <p class="text-gray-700 mb-4">
                  Av. Historiador Rubens de Mendonça, 3300 - Piso Térreo -
                  Jardim Aclimacao, Cuiabá, Cuiabá - MT
                </p>
              </div>

              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Shopping Sinop</h3>
                </div>
                <p class="text-gray-700 mb-4">
                  Av. Alexandre Ferronato, 800 - Piso Térreo, Sinop - MT
                </p>
              </div>

              <div class="border-b pb-6">
                <div class="flex justify-between items-center mb-4">
                  <h3 class="text-lg font-bold">Rondon Plaza Shopping</h3>
                  <span
                    class="bg-[#FF0080] text-white text-xs px-3 py-1 rounded-full"
                    >Loja nova!</span
                  >
                </div>
                <p class="text-gray-700 mb-4">
                  Av. Rotary Internacional, 1950 - Parque Sagrada Família - Piso
                  Térreo, Rondonópolis
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>

    <!-- Footer -->
    <footer class="py-6" style="background-color: #ff0080; color: white">
      <div class="container mx-auto px-4">
        <!-- Logo e ícones sociais -->
        <div class="flex justify-center mb-6">
          <a href="../">
            <img
              src="../assets1/footer-img.png"
              alt="WePink Logo e ícones sociais"
              class="max-w-full"
            />
          </a>
        </div>

        <!-- Links de navegação -->
        <div class="grid grid-cols-1 text-center mb-6">
          <div>
            <ul>
              <li class="mb-3">
                <a
                  href="/sobre-nos"
                  class="text-white hover:text-white flex items-center justify-center"
                >
                  sobre nós →
                </a>
              </li>
              <li class="mb-3">
                <a
                  href="/rastreio"
                  class="text-white hover:text-white flex items-center justify-center"
                >
                  central de ajuda →
                </a>
              </li>
              <li class="mb-3">
                <a
                  href="/trocas"
                  class="text-white hover:text-white flex items-center justify-center"
                >
                  troca e devoluções →
                </a>
              </li>
              <li class="mb-3">
                <a
                  href="/rastreio"
                  class="text-white hover:text-white flex items-center justify-center"
                >
                  consulte sua entrega →
                </a>
              </li>
              <li class="mb-3">
                <a
                  href="/lojas"
                  class="text-white hover:text-white flex items-center justify-center"
                >
                  franquias →
                </a>
              </li>
            </ul>
          </div>
        </div>

        <!-- Formas de pagamento -->
        <div class="text-center mb-6">
          <h4 class="font-bold mb-4">Formas de pagamento</h4>
          <div class="flex justify-center">
            <div class="flex flex-wrap items-center gap-4 py-3">
              <img
                src="../assets1/visa.svg"
                alt="Visa"
                class="w-12 h-12"
                loading="lazy"
              />
              <img
                src="../assets1/mastercard.svg"
                alt="Mastercard"
                class="w-12 h-12"
                loading="lazy"
              />
              <img
                src="../assets1/diners.svg"
                alt="Diners Club"
                class="w-12 h-12"
                loading="lazy"
              />
              <img
                src="../assets1/amex.svg"
                alt="American Express"
                class="w-12 h-12"
                loading="lazy"
              />
            </div>
          </div>
          <div class="flex justify-center">
            <img src="../assets1/pix.svg" alt="Pix" class="w-16 h-16" />
          </div>
        </div>

        <!-- Voltar ao topo -->
        <div class="text-center mb-6">
          <a
            href="#"
            class="text-white hover:text-white inline-flex items-center"
          >
            <span
              class="inline-block w-6 h-6 bg-white rounded-full text-pink-500 flex items-center justify-center mr-2"
              >↑</span
            >
            voltar ao topo
          </a>
        </div>

        <!-- Política e Termos -->
        <div class="text-center mb-6">
          <a href="/politica-de-privacidade" class="text-white hover:text-white"
            >Política de Privacidade</a
          >
          <span class="mx-2">|</span>
          <a href="/termos-de-uso" class="text-white hover:text-white"
            >Termos de Uso</a
          >
        </div>

        <!-- Copyright -->
        <div class="text-center text-sm">
          <p>
            Todos os direitos reservados © 2025 | SAVI COSMÉTICOS LTDA | CNPJ:
            42.422.967/0001-01
          </p>
        </div>
      </div>
    </footer>

    <script>
      document.addEventListener("DOMContentLoaded", function () {
        // Selecionando todos os botões de abas e todos os conteúdos de estados
        const stateTabs = document.querySelectorAll(".state-tab");
        const stateContents = document.querySelectorAll(".state-content");

        // Função para mostrar o conteúdo do estado selecionado
        function showStateContent(stateId) {
          console.log("Função chamada para mostrar estado: " + stateId);

          // Oculta todos os conteúdos
          stateContents.forEach((content) => {
            content.classList.add("hidden");
          });

          // Remove o destaque de todos os botões
          stateTabs.forEach((tab) => {
            const icon = tab.querySelector("i");
            tab.classList.remove("text-[#FF0080]");
            if (icon) icon.classList.remove("text-[#FF0080]");
          });

          // Mostra o conteúdo do estado selecionado
          const selectedContent = document.getElementById(stateId + "-content");
          if (selectedContent) {
            selectedContent.classList.remove("hidden");
            console.log("Conteúdo encontrado e mostrado: " + stateId);
          } else {
            console.log("Conteúdo não encontrado para: " + stateId);
          }

          // Adiciona destaque ao botão selecionado
          const selectedTab = document.querySelector(
            `[data-state="${stateId}"]`
          );
          if (selectedTab) {
            selectedTab.classList.add("text-[#FF0080]");
            const icon = selectedTab.querySelector("i");
            if (icon) icon.classList.add("text-[#FF0080]");

            // Atualiza o indicador ativo
            const tabRect = selectedTab.getBoundingClientRect();
            const tabsContainer = selectedTab.parentElement;
            const containerRect = tabsContainer.getBoundingClientRect();
          }
        }

        // Adiciona evento de clique a cada aba
        stateTabs.forEach((tab) => {
          tab.addEventListener("click", function (e) {
            e.preventDefault();
            const stateId = this.getAttribute("data-state");
            console.log("Clique em estado: " + stateId);
            showStateContent(stateId);
          });
        });

        // Mostra o conteúdo de Alagoas por padrão ao carregar a página
        setTimeout(() => {
          showStateContent("alagoas");
        }, 100);

        // Adiciona funcionalidade aos botões de expandir detalhes das lojas
        const expandButtons = document.querySelectorAll(
          ".state-content button"
        );
        expandButtons.forEach((button) => {
          button.addEventListener("click", function () {
            const storeDetails = this.parentElement;
            const isExpanded = storeDetails.classList.contains("expanded");

            if (isExpanded) {
              storeDetails.classList.remove("expanded");
              //this.innerHTML = '<i class="fas fa-chevron-down"></i>';
            } else {
              storeDetails.classList.add("expanded");
              //this.innerHTML = '<i class="fas fa-chevron-up"></i>';
            }
          });
        });
      });
    </script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
      // Estrutura para armazenar os produtos
      let carrinho = {
        itens: [],
        total: 0,
        desconto: 0,
      };

      // Função para inicializar o carrinho
      function inicializarCarrinho() {
        console.log("Inicializando carrinho...");
        const carrinhoSalvo = localStorage.getItem("wepinkCarrinho");

        if (carrinhoSalvo) {
          console.log("Carrinho encontrado no localStorage");
          carrinho = JSON.parse(carrinhoSalvo);
          atualizarContadorCarrinho();
          console.log("Carrinho carregado:", carrinho);
        } else {
          console.log("Nenhum carrinho encontrado, criando novo");
          localStorage.setItem("wepinkCarrinho", JSON.stringify(carrinho));
        }
      }

      // Função para salvar o carrinho no localStorage
      function salvarCarrinho() {
        console.log("Salvando carrinho no localStorage...");
        localStorage.setItem("wepinkCarrinho", JSON.stringify(carrinho));
        console.log("Carrinho salvo:", carrinho);
      }

      // Função para exibir a mensagem de limite excedido
      function exibirMensagemLimite() {
        // Cria o elemento de mensagem se não existir
        let mensagemElement = document.getElementById("mensagem-limite");

        if (!mensagemElement) {
          mensagemElement = document.createElement("div");
          mensagemElement.id = "mensagem-limite";
          mensagemElement.className =
            "fixed top-4 right-4 bg-red-500 text-white p-4 rounded-md shadow-lg z-50";
          mensagemElement.style.maxWidth = "300px";
          mensagemElement.style.opacity = "0";
          mensagemElement.style.transition = "opacity 0.3s ease";
          document.body.appendChild(mensagemElement);
        }

        // Define o conteúdo e exibe a mensagem
        mensagemElement.textContent = "Valor máximo por carrinho: R$1.000,00";
        mensagemElement.style.opacity = "1";

        // Oculta a mensagem após 3 segundos
        setTimeout(() => {
          mensagemElement.style.opacity = "0";

          // Remove o elemento após a animação de fade out
          setTimeout(() => {
            if (mensagemElement && mensagemElement.parentNode) {
              mensagemElement.parentNode.removeChild(mensagemElement);
            }
          }, 300);
        }, 3000);
      }

      // Função para verificar se adicionar um produto excederá o limite
      function verificarLimiteCarrinho(valorAdicional) {
        const totalAtual = carrinho.itens.reduce(
          (sum, item) => sum + item.preco * item.quantidade,
          0
        );

        return totalAtual + valorAdicional <= 1000;
      }

      // Função para capturar os cliques nos botões "COMPRAR"
      function configurarBotoesComprar() {
        console.log("Configurando botões de comprar...");
        const botoesComprar = document.querySelectorAll(".btn-comprar");

        botoesComprar.forEach((botao, index) => {
          botao.addEventListener("click", function (e) {
            e.preventDefault();

            // Obter informações do produto
            const produtoElement = this.closest(".produto-element");
            const nomeProduto = produtoElement
              .querySelector("h3")
              .textContent.trim();
            const precoAntigoText = produtoElement
              .querySelector(".preco-antigo")
              .textContent.trim();
            const precoAtualText = produtoElement
              .querySelector(".preco-atual")
              .textContent.trim();
            const imagemProduto = produtoElement.querySelector("img").src;

            // Extrair valores numéricos
            const precoAntigo = parseFloat(
              precoAntigoText.replace("De R$", "").replace(",", ".").trim()
            );
            const precoAtual = parseFloat(
              precoAtualText.replace("R$", "").replace(",", ".").trim()
            );

            // Usar um ID no formato começando do 1
            const produtoId = `${index + 1}`;

            console.log("Produto clicado:", {
              id: produtoId,
              nome: nomeProduto,
              precoAntigo,
              precoAtual,
              imagem: imagemProduto,
            });

            // Adicionar ao carrinho com ID formatado
            adicionarAoCarrinho({
              id: produtoId,
              nome: nomeProduto,
              precoAntigo: precoAntigo,
              preco: precoAtual,
              imagem: imagemProduto,
            });

            // Rastrear evento para o Facebook Pixel
            if (typeof fbq === "function") {
              fbq("track", "AddToCart", {
                content_name: nomeProduto,
                content_ids: [produtoId],
                content_type: "product",
                value: precoAtual,
                currency: "BRL",
              });
            }
          });
        });

        // Configurar o botão de carrinho do header
        const botaoCarrinho = document.querySelector(
          ".fas.fa-shopping-cart"
        ).parentNode;
        botaoCarrinho.addEventListener("click", function (e) {
          e.preventDefault();
          abrirModalCarrinho();
        });
      }

      // Função modificada para adicionar produto ao carrinho
      function adicionarAoCarrinho(produto) {
        console.log("Adicionando produto ao carrinho:", produto);

        // Verificar se o produto já existe no carrinho
        const itemExistente = carrinho.itens.find(
          (item) => item.id === produto.id
        );

        // Verificar limite do carrinho
        const valorAdicional = itemExistente ? produto.preco : produto.preco;

        if (!verificarLimiteCarrinho(valorAdicional)) {
          console.log(
            "Limite de R$1000 excedido. Não é possível adicionar o produto."
          );
          exibirMensagemLimite();
          return;
        }

        if (itemExistente) {
          console.log("Produto já existe no carrinho, aumentando quantidade");
          itemExistente.quantidade += 1;
        } else {
          console.log("Adicionando novo produto ao carrinho");
          carrinho.itens.push({
            ...produto,
            quantidade: 1,
          });
        }

        // Atualizar totais
        atualizarTotais();
        atualizarContadorCarrinho();
        salvarCarrinho();

        // Mostrar o modal do carrinho
        abrirModalCarrinho();
      }

      // Função para remover um item do carrinho
      function removerDoCarrinho(produtoId) {
        console.log("Removendo produto do carrinho:", produtoId);
        carrinho.itens = carrinho.itens.filter((item) => item.id !== produtoId);

        // Atualizar totais
        atualizarTotais();
        atualizarContadorCarrinho();
        salvarCarrinho();

        // Atualizar o modal
        renderizarCarrinho();
      }

      // Função modificada para aumentar a quantidade de um item com verificação de limite
      function aumentarQuantidade(produtoId) {
        console.log("Aumentando quantidade do produto:", produtoId);
        const item = carrinho.itens.find((item) => item.id === produtoId);

        if (item) {
          // Verificar se aumentar a quantidade excederá o limite
          if (!verificarLimiteCarrinho(item.preco)) {
            console.log(
              "Limite de R$1000 excedido. Não é possível aumentar a quantidade."
            );
            exibirMensagemLimite();
            return;
          }

          item.quantidade += 1;
          atualizarTotais();
          atualizarContadorCarrinho();
          salvarCarrinho();
          renderizarCarrinho();
        }
      }

      // Função para diminuir a quantidade de um item
      function diminuirQuantidade(produtoId) {
        console.log("Diminuindo quantidade do produto:", produtoId);
        const item = carrinho.itens.find((item) => item.id === produtoId);

        if (item) {
          item.quantidade -= 1;

          // Se a quantidade for 0 ou menor, remover o item
          if (item.quantidade <= 0) {
            removerDoCarrinho(produtoId);
            return;
          }

          atualizarTotais();
          atualizarContadorCarrinho();
          salvarCarrinho();
          renderizarCarrinho();
        }
      }

      // Função para atualizar os totais
      function atualizarTotais() {
        console.log("Atualizando totais do carrinho...");
        let novoTotal = 0;
        let novoDesconto = 0;

        // Processar todos os itens sem filtro
        carrinho.itens.forEach((item) => {
          novoTotal += item.preco * item.quantidade;
          novoDesconto += (item.precoAntigo - item.preco) * item.quantidade;
        });

        // Garantir que o total não ultrapasse R$1000
        if (novoTotal > 1000) {
          console.log("Total ajustado para o limite máximo de R$1000");
          novoTotal = 1000;
        }

        carrinho.total = novoTotal;
        carrinho.desconto = novoDesconto;

        console.log(
          "Novos valores - Total:",
          novoTotal,
          "Desconto:",
          novoDesconto
        );
      }

      // Função para atualizar o contador do ícone do carrinho
      function atualizarContadorCarrinho() {
        console.log("Atualizando contador do carrinho...");

        const contador = carrinho.itens.reduce(
          (total, item) => total + item.quantidade,
          0
        );

        // Verificar se o contador já existe
        let contadorElement = document.getElementById("contador-carrinho");

        if (!contadorElement) {
          console.log("Criando elemento contador...");
          contadorElement = document.createElement("span");
          contadorElement.id = "contador-carrinho";
          contadorElement.className =
            "absolute -top-1 -right-1 bg-[#FF0080] text-white text-xs rounded-full h-5 w-5 flex items-center justify-center";

          const cartButton = document.querySelector(
            ".fas.fa-shopping-cart"
          ).parentNode;
          cartButton.style.position = "relative";
          cartButton.appendChild(contadorElement);
        }

        // Atualizar o valor do contador
        contadorElement.textContent = contador;

        // Mostrar ou esconder o contador
        contadorElement.style.display = contador > 0 ? "flex" : "none";

        console.log("Contador atualizado:", contador);
      }

      // Função para abrir o modal do carrinho
      function abrirModalCarrinho() {
        console.log("Abrindo modal do carrinho...");

        // Verificar se o modal já existe
        let modalCarrinho = document.getElementById("modal-carrinho");

        if (!modalCarrinho) {
          console.log("Criando modal do carrinho...");
          modalCarrinho = document.createElement("div");
          modalCarrinho.id = "modal-carrinho";
          modalCarrinho.className =
            "fixed top-0 right-0 h-full w-full md:w-96 bg-white shadow-lg z-50 transform transition-transform duration-300 flex flex-col";
          modalCarrinho.style.transform = "translateX(100%)";

          document.body.appendChild(modalCarrinho);
        }

        // Renderizar o conteúdo do carrinho
        renderizarCarrinho();

        // Mostrar o modal
        setTimeout(() => {
          modalCarrinho.style.transform = "translateX(0)";
        }, 10);
      }

      // Função para fechar o modal do carrinho
      function fecharModalCarrinho() {
        console.log("Fechando modal do carrinho...");
        const modalCarrinho = document.getElementById("modal-carrinho");

        if (modalCarrinho) {
          modalCarrinho.style.transform = "translateX(100%)";
        }
      }

      // Função para renderizar o conteúdo do carrinho
      function renderizarCarrinho() {
        console.log("Renderizando conteúdo do carrinho...");
        const modalCarrinho = document.getElementById("modal-carrinho");

        if (modalCarrinho) {
          const content = `
          <div class="bg-[#FF0080] text-white p-4 flex justify-between items-center">
            <div class="flex items-center text-lg font-bold">
              <i class="fas fa-shopping-cart mr-2"></i> Seu Carrinho
            </div>
            <button onclick="fecharModalCarrinho()" class="text-2xl font-bold">&times;</button>
          </div>
          
          <div class="flex-grow overflow-auto p-4">
            ${
              carrinho.itens.length === 0
                ? '<p class="text-center text-gray-500 mt-10">Seu carrinho está vazio</p>'
                : carrinho.itens
                    .map(
                      (item) => `
                <div class="flex items-center border-b py-4" data-id="${
                  item.id
                }">
                  <div class="w-20">
                    <img src="${item.imagem}" alt="${item.nome}" class="w-full">
                  </div>
                  <div class="flex-grow px-4">
                    <h3 class="text-base font-semibold">${item.nome}</h3>
                    <div class="text-gray-500 text-xs line-through">R$ ${item.precoAntigo
                      .toFixed(2)
                      .replace(".", ",")}</div>
                    <div class="text-[#FF0080] font-bold">R$ ${item.preco
                      .toFixed(2)
                      .replace(".", ",")}</div>
                  </div>
                  <div class="flex items-center">
                    <button onclick="diminuirQuantidade('${
                      item.id
                    }')" class="bg-[#FF0080] text-white w-6 h-6 rounded-full flex items-center justify-center">-</button>
                    <span class="mx-2">${item.quantidade}</span>
                    <button onclick="aumentarQuantidade('${
                      item.id
                    }')" class="bg-[#FF0080] text-white w-6 h-6 rounded-full flex items-center justify-center">+</button>
                  </div>
                </div>
              `
                    )
                    .join("")
            }
          </div>
          
          <div class="border-t p-4">
            <div class="flex justify-between mb-2">
              <span class="font-bold">Entrega:</span>
              <span class="text-[#FF0080] font-bold">Grátis</span>
            </div>
            <div class="flex justify-between mb-4">
              <span class="font-bold">Total:</span>
              <span class="text-[#FF0080] font-bold">R$ ${carrinho.total
                .toFixed(2)
                .replace(".", ",")}</span>
            </div>
            <div class="grid grid-cols-2 gap-4">
              <button onclick="fecharModalCarrinho()" class="border border-[#FF0080] text-[#FF0080] py-2 rounded text-center font-bold">
                Continuar Comprando
              </button>
              <a href="<?php echo utm_append_to_url('/checkout'); ?>" class="bg-[#FF0080] text-white py-2 rounded text-center font-bold inline-block px-4">
                Finalizar Compra
              </a>
            </div>
          </div>
        `;

          modalCarrinho.innerHTML = content;
        }
      }

      // Inicializar quando o DOM estiver pronto
      document.addEventListener("DOMContentLoaded", function () {
        console.log("DOM carregado, inicializando sistema de carrinho...");
        inicializarCarrinho();
        configurarBotoesComprar();
      });

      // Garantir que o script é chamado mesmo se o DOM já estiver carregado
      if (document.readyState === "loading") {
        document.addEventListener("DOMContentLoaded", function () {
          console.log("DOM ainda carregando, aguardando...");
        });
      } else {
        console.log("DOM já carregado, inicializando imediatamente...");
        inicializarCarrinho();
        configurarBotoesComprar();
      }
    </script>
  </body>
</html>
