<?php
/**
 * Página de teste para API de Conversões do Facebook
 * 
 * Este arquivo demonstra como usar a API de Conversões do Facebook
 * em diferentes estágios da jornada de conversão.
 */

// Inicia a sessão - necessário para manter estado entre páginas
session_start();

// Inclui as classes do Facebook
require_once 'FacebookAttributionHelper.php';
require_once 'FacebookConversionAPI.php';

// Captura e armazena o FBCLID se presente na URL
$fbc = FacebookAttributionHelper::captureFbclid();

// Suas configurações do Facebook
$config = [
    'access_token' => 'EAAPNK6HLWHwBQGykDwh6TiPsSwCw67CMZCyVIwmZAuDGAv7pRuoRlYfZCdkJJLim4DdM720IysAjD2ZBdo55pZB8ZAje9NzmSNXTvDvedx0Egwo0F9ZAB0hdo8icPQoUlwUOs7pRaasfbrN4pC4qJZBw7RwyycZBen0CuZBNVSJHiK9LUcn5bBD8MYZBHN7ZAZA16TQZDZD',
    'pixel_id' => '806911238441130',
    'api_version' => 'v18.0',
    'debug_mode' => true,
    'test_event_code' => 'TEST79847' // Use o código de teste do seu Business Manager
];

// Dados de teste do usuário
$user_data = [
    'email' => 'teste@exemplo.com.br',
    'phone' => '5511999998888',
    'first_name' => 'João',
    'last_name' => 'Silva',
    'city' => 'São Paulo',
    'state' => 'SP',
    'zip' => '01310100',
    'external_id' => '123456' // ID do usuário no seu sistema
];

// Produto de exemplo
$product = [
    'id' => 'SKU12345',
    'name' => 'Celular Exemplo Pro Max',
    'price' => 1999.90,
    'category' => 'Eletrônicos > Celulares',
    'quantity' => 1
];

// Dados do carrinho
$cart = [
    'items' => [
        [
            'id' => $product['id'],
            'name' => $product['name'],
            'price' => $product['price'],
            'quantity' => $product['quantity']
        ]
    ],
    'total' => $product['price'] * $product['quantity']
];

// Dados do pedido
$order = [
    'id' => 'ORD' . time(),
    'total' => $cart['total'],
    'shipping' => 15.90,
    'payment_method' => 'credit_card'
];

// Função para limpar a saída
function printResult($title, $result) {
    echo "<div style='margin: 20px 0; padding: 15px; border: 1px solid #ddd; border-radius: 4px;'>";
    echo "<h3>{$title}</h3>";
    echo "<pre>" . json_encode($result, JSON_PRETTY_PRINT) . "</pre>";
    echo "</div>";
}

// Inicializa a API
$fbConversion = new FacebookConversionAPI(
    $config['access_token'],
    $config['pixel_id'],
    $config['api_version'],
    $config['debug_mode'],
    $config['test_event_code']
);

// Processa a ação requisitada
$action = $_GET['action'] ?? '';

switch ($action) {
    case 'page_view':
        // Simula visualização de página
        $page_data = [
            'page_title' => 'Página Inicial - Loja Virtual',
            'page_url' => 'https://www.seusite.com.br/',
            'page_referrer' => $_SERVER['HTTP_REFERER'] ?? '',
            'source_url' => 'https://www.seusite.com.br/'
        ];
        
        $result = $fbConversion->sendPageViewEvent($page_data, $user_data);
        printResult("Evento PageView", $result);
        break;
        
    case 'view_content':
        // Simula visualização de produto
        $event_data = [
            'product_ids' => [$product['id']],
            'content_name' => $product['name'],
            'content_category' => $product['category'],
            'currency' => 'BRL',
            'value' => $product['price'],
            'source_url' => "https://www.seusite.com.br/produto/{$product['id']}"
        ];
        
        $result = $fbConversion->sendEvent('ViewContent', $event_data, $user_data);
        printResult("Evento ViewContent", $result);
        break;
        
    case 'add_to_cart':
        // Simula adição ao carrinho
        $event_data = [
            'product_ids' => [$product['id']],
            'currency' => 'BRL',
            'value' => $cart['total'],
            'contents' => [
                [
                    'id' => $product['id'],
                    'quantity' => $product['quantity'],
                    'item_price' => $product['price']
                ]
            ],
            'cart_id' => session_id(),
            'source_url' => "https://www.seusite.com.br/carrinho"
        ];
        
        $result = $fbConversion->sendAddToCartEvent($event_data, $user_data);
        printResult("Evento AddToCart", $result);
        break;
        
    case 'initiate_checkout':
        // Simula início de checkout
        $event_data = [
            'product_ids' => [$product['id']],
            'currency' => 'BRL',
            'value' => $cart['total'],
            'num_items' => $product['quantity'],
            'checkout_id' => session_id(),
            'source_url' => "https://www.seusite.com.br/checkout"
        ];
        
        $result = $fbConversion->sendInitiateCheckoutEvent($event_data, $user_data);
        printResult("Evento InitiateCheckout", $result);
        break;
        
    case 'purchase':
        // Simula finalização de compra
        $event_data = [
            'order_id' => $order['id'],
            'product_ids' => [$product['id']],
            'currency' => 'BRL',
            'value' => $cart['total'],
            'source_url' => "https://www.seusite.com.br/checkout/confirmacao"
        ];
        
        $custom_data = [
            'payment_method' => $order['payment_method'],
            'shipping_cost' => $order['shipping'],
            'coupon_code' => $_GET['coupon'] ?? null
        ];
        
        $event_id = FacebookAttributionHelper::generateEventId('Purchase', $order['id']);
        $result = $fbConversion->sendPurchaseEvent($event_data, $user_data, $custom_data, $event_id);
        printResult("Evento Purchase", $result);
        break;
        
    default:
        // Página inicial com links para testar cada evento
        break;
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teste da API de Conversões do Facebook</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .card {
            border: 1px solid #ddd;
            border-radius: 4px;
            padding: 20px;
            margin-bottom: 20px;
        }
        h1, h2 {
            color: #333;
        }
        .button {
            display: inline-block;
            background-color: #4267B2;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 4px;
            margin-right: 10px;
            margin-bottom: 10px;
        }
        .info {
            background-color: #f9f9f9;
            padding: 15px;
            border-left: 4px solid #4267B2;
            margin-bottom: 20px;
        }
        pre {
            background-color: #f5f5f5;
            padding: 10px;
            overflow: auto;
        }
    </style>
</head>
<body>
    <h1>Teste da API de Conversões do Facebook</h1>
    
    <div class="info">
        <p><strong>Status do FBC (Facebook Click ID):</strong> <?php echo $fbc ? "Capturado: $fbc" : "Não detectado"; ?></p>
        <p><strong>Status do FBP (Facebook Browser ID):</strong> <?php echo FacebookAttributionHelper::getFbp() ? "Detectado: " . FacebookAttributionHelper::getFbp() : "Não detectado"; ?></p>
    </div>
    
    <?php if (!$action): ?>
        <div class="card">
            <h2>Como usar esta página de teste</h2>
            <p>Esta página permite testar a integração com a API de Conversões do Facebook em diferentes estágios da jornada de conversão.</p>
            <p>Para simular um clique em anúncio do Facebook, acesse esta página com o parâmetro <code>fbclid</code>:</p>
            <p><code><?php echo "http://$_SERVER[HTTP_HOST]$_SERVER[PHP_SELF]?fbclid=IwAR123456789"; ?></code></p>
            <p>Em seguida, clique nos botões abaixo para testar cada tipo de evento:</p>
        </div>
        
        <h2>Escolha um evento para testar:</h2>
        <p>
            <a href="?action=page_view" class="button">PageView (Visualizar Página)</a>
            <a href="?action=view_content" class="button">Visualizar Produto</a>
            <a href="?action=add_to_cart" class="button">Adicionar ao Carrinho</a>
            <a href="?action=initiate_checkout" class="button">Iniciar Checkout</a>
            <a href="?action=purchase" class="button">Finalizar Compra</a>
        </p>
        
        <div class="card">
            <h2>Detalhes de teste</h2>
            <h3>Produto de exemplo:</h3>
            <pre><?php echo json_encode($product, JSON_PRETTY_PRINT); ?></pre>
            
            <h3>Dados do usuário de teste:</h3>
            <pre><?php echo json_encode($user_data, JSON_PRETTY_PRINT); ?></pre>
        </div>
    <?php else: ?>
        <p><a href="<?php echo $_SERVER['PHP_SELF']; ?>" class="button">← Voltar</a></p>
    <?php endif; ?>
</body>
</html>