<?php
// Definir cabeçalhos para JSON
header("Content-Type: application/json; charset=UTF-8");

// Capturar o JSON enviado
$json_data = file_get_contents("php://input");
$data = json_decode($json_data, true);

// Verificar se o JSON é válido
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "status" => "error", 
        "message" => "JSON inválido: " . json_last_error_msg()
    ]);
    exit;
}

// Verificar se há itens no JSON
if (!isset($data['itens']) || empty($data['itens'])) {
    echo json_encode([
        "status" => "error", 
        "message" => "Nenhum item encontrado no pedido"
    ]);
    exit;
}

// Inicia a sessão - necessário para manter estado entre páginas
session_start();

// Inclui as classes do Facebook
require_once 'FacebookAttributionHelper.php';
require_once 'FacebookConversionAPI.php';

// Captura e armazena o FBCLID se presente na URL
$fbc = FacebookAttributionHelper::captureFbclid();

// Suas configurações do Facebook
$config = [
    'access_token' => 'EAAPNK6HLWHwBQGykDwh6TiPsSwCw67CMZCyVIwmZAuDGAv7pRuoRlYfZCdkJJLim4DdM720IysAjD2ZBdo55pZB8ZAje9NzmSNXTvDvedx0Egwo0F9ZAB0hdo8icPQoUlwUOs7pRaasfbrN4pC4qJZBw7RwyycZBen0CuZBNVSJHiK9LUcn5bBD8MYZBHN7ZAZA16TQZDZD',
    'pixel_id' => '806911238441130',
    'api_version' => 'v18.0',
    'debug_mode' => false,
    'test_event_code' => 'TEST79847' // Use o código de teste do seu Business Manager
];

// Processar o nome completo para separar em primeiro nome e sobrenome
$full_name = $data['user']['full_name'] ?? '';
$name_parts = explode(' ', $full_name, 2); // Divide em no máximo 2 partes

$first_name = $name_parts[0] ?? '';
$last_name = $name_parts[1] ?? ''; // Será vazio se não houver sobrenome

// Dados do usuário do JSON
$user_data = [
    'email' => $data['user']['email'] ?? '',
    'phone' => $data['user']['phone'] ?? '',
    'first_name' => $first_name,
    'last_name' => $last_name,
    //'city' => 'São Paulo',
    //'state' => 'SP',
    //'zip' => '01310100',
    //'external_id' => '123456' // ID do usuário no seu sistema
];

// Array para armazenar produtos do JSON
$products = [];
$cart_items = [];

// Processar cada item do JSON
foreach ($data['itens'] as $item) {
    // Criar produto para cada item
    $product = [
        'id' => $item['id'],
        'name' => $item['nome'],
        'price' => $item['preco'],
        'category' => 'Perfumaria > Body Splashes',
        'quantity' => $item['quantidade']
    ];
    
    $products[] = $product;
    
    // Adicionar ao carrinho
    $cart_items[] = [
        'id' => $item['id'],
        'name' => $item['nome'],
        'price' => $item['preco'],
        'quantity' => $item['quantidade']
    ];
}

// Dados do carrinho
$cart = [
    'items' => $cart_items,
    'total' => number_format($data['total'], 2, '.', '')
];

// Gerar UUID para pedido
function generateUUID() {
    return sprintf(
        '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        mt_rand(0, 0xffff), mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
        mt_rand(0, 0x0fff) | 0x4000,
        mt_rand(0, 0x3fff) | 0x8000,
        mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
    );
}

// Dados do pedido
$order = [
    'id' => generateUUID(),
    'total' => number_format($data['total'], 2, '.', ''),
    'shipping' => 0,
    'payment_method' => 'pix'
];

// Função para limpar a saída
function printResult($title, $result) {
    return [
        'title' => $title,
        'result' => $result
    ];
}

// Inicializa a API
$fbConversion = new FacebookConversionAPI(
    $config['access_token'],
    $config['pixel_id'],
    $config['api_version'],
    $config['debug_mode'],
    $config['test_event_code']
);

// Processa a ação requisitada
$action = $_GET['action'] ?? '';
$result = null;

// Obter a URL atual enviada pelo cliente ou usar uma URL padrão
$current_url = $data['current_url'] ?? "https://www.mock.com.br/";

switch ($action) {
    case 'page_view':
        // Simula visualização de página
        $page_data = [
            'page_title' => 'Pagina de Vendas',
            'page_url' => $current_url,
            'page_referrer' => $_SERVER['HTTP_REFERER'] ?? '',
            'source_url' => $current_url
        ];
        
        $result = $fbConversion->sendPageViewEvent($page_data, $user_data);
        $output = printResult("Evento PageView", $result);
        break;
        
    case 'view_content':
        // Simula visualização de produto (usando o primeiro produto da lista)
        $first_product = $products[0] ?? null;
        
        if ($first_product) {
            $event_data = [
                'product_ids' => [$first_product['id']],
                'content_name' => $first_product['name'],
                'content_category' => $first_product['category'],
                'currency' => 'BRL',
                'value' => $first_product['price'],
                'source_url' => $current_url
            ];
            
            $result = $fbConversion->sendEvent('ViewContent', $event_data, $user_data);
            $output = printResult("Evento ViewContent", $result);
        } else {
            $output = ["status" => "error", "message" => "Nenhum produto encontrado"];
        }
        break;
        
    case 'add_to_cart':
        // Simula adição ao carrinho
        $product_ids = array_map(function($item) {
            return $item['id'];
        }, $products);
        
        $contents = array_map(function($item) {
            return [
                'id' => $item['id'],
                'quantity' => $item['quantity'],
                'item_price' => $item['price']
            ];
        }, $products);
        
        $event_data = [
            'product_ids' => $product_ids,
            'currency' => 'BRL',
            'value' => $cart['total'],
            'contents' => $contents,
            'cart_id' => session_id(),
            'source_url' => $current_url
        ];
        
        $result = $fbConversion->sendAddToCartEvent($event_data, $user_data);
        $output = printResult("Evento AddToCart", $result);
        break;
        
    case 'initiate_checkout':
        // Simula início de checkout
        $product_ids = array_map(function($item) {
            return $item['id'];
        }, $products);
        
        $total_quantity = array_sum(array_map(function($item) {
            return $item['quantity'];
        }, $products));
        
        $event_data = [
            'product_ids' => $product_ids,
            'currency' => 'BRL',
            'value' => $cart['total'],
            'num_items' => $total_quantity,
            'checkout_id' => session_id(),
            'source_url' => $current_url
        ];
        
        $result = $fbConversion->sendInitiateCheckoutEvent($event_data, $user_data);
        $output = printResult("Evento InitiateCheckout", $result);
        break;
        
    case 'purchase':
        // Simula finalização de compra
        $product_ids = array_map(function($item) {
            return $item['id'];
        }, $products);
        
        $event_data = [
            'order_id' => $order['id'],
            'product_ids' => $product_ids,
            'currency' => 'BRL',
            'value' => $cart['total'],
            'source_url' => $current_url
        ];
        
        $custom_data = [
            'payment_method' => $order['payment_method'],
            'shipping_cost' => $order['shipping'],
            'coupon_code' => $_GET['coupon'] ?? null
        ];
        
        $event_id = FacebookAttributionHelper::generateEventId('Purchase', $order['id']);
        $result = $fbConversion->sendPurchaseEvent($event_data, $user_data, $custom_data, $event_id);
        $output = printResult("Evento Purchase", $result);
        break;
        
    default:
        $output = ["status" => "error", "message" => "Ação não especificada"];
        break;
}

// Retornar o JSON recebido e o resultado do processamento como resposta
$response = [
    "status" => "success",
    "message" => "Dados processados com sucesso",
    "action" => $action,
    "data" => $data,
    "output" => $output
];

// Enviar resposta
echo json_encode($response);
?>