<?php
// Verifica se o método de requisição é POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("HTTP/1.1 403 Forbidden");
    exit('Acesso negado.');
}

// Suporte a JSON no corpo da requisição
if (strpos($_SERVER["CONTENT_TYPE"], "application/json") !== false) {
    $json = file_get_contents("php://input");
    $data = json_decode($json, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        // Processa os dados recebidos
        $tipoErro = $data['tipo'];
        $mensagemErro = $data['mensagem'];
        $dataHora = $data['dataHora'];

        // Criar o log com a data e hora de SP
        $logMessage = "[$dataHora] - Tipo: $tipoErro - Mensagem: $mensagemErro" . PHP_EOL;

        // Caminho do arquivo de log
        $logFile = 'ERROS_DO_ENVIO_DO_PURCHASE_FACE.txt'; // Substitua com o caminho correto do seu arquivo

        // Escrever no arquivo de log
        file_put_contents($logFile, $logMessage, FILE_APPEND);
    } else {
        header("HTTP/1.1 400 Bad Request");
        echo "Erro ao processar o JSON.";
    }
} else {
    header("HTTP/1.1 405 Method Not Allowed");
    echo "Método não permitido.";
}
?>
