<?php 

// Verifica se o método de requisição é POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("HTTP/1.1 403 Forbidden");
    exit('Acesso negado.');
}

// Adaptação para aceitar JSON no corpo da requisição
if (strpos($_SERVER["CONTENT_TYPE"], "application/json") !== false) {
    $json = file_get_contents("php://input");
    $data = json_decode($json, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        $_POST = $data;
    }
}

// Array de parâmetros obrigatórios
$parametrosObrigatorios = [
    'id_transacao' => 'Id Transacao'
];

// Array para armazenar parâmetros faltantes
$parametrosFaltantes = [];

// Verifica cada parâmetro obrigatório
foreach ($parametrosObrigatorios as $parametro => $descricao) {
    if (!isset($_POST[$parametro]) || $_POST[$parametro] === '') {
        $parametrosFaltantes[] = $descricao;
    }
}

// Se houver parâmetros faltantes, retorna um erro detalhado
if (!empty($parametrosFaltantes)) {
    header("HTTP/1.1 400 Bad Request");
    $mensagemErro = "Os seguintes parâmetros estão faltando: " . implode(', ', $parametrosFaltantes);
    exit($mensagemErro);
}

//Sua secret_key
$secretKey = 'sk_live_OYccvgIIDu115CqaVJmjddA3cidiukt9zp1YM90Rft'; 
//Recebido via post da função "statusPagamento" na página "index.php" linha: 102
$id_transacao = $_POST['id_transacao'];

$curl = curl_init(); 
//Realiza o request passando o id da transação para consultar o status.
curl_setopt_array($curl, [
  CURLOPT_URL => "https://api.v2.rpxpay.com/v1/transactions/$id_transacao",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
 CURLOPT_HTTPHEADER => [
    "accept: application/json",
    "authorization: Basic " . base64_encode($secretKey . ":x"),  
    "content-type: application/json"
  ],
]);
// Recebe o return do gateway em formato json
$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

if ($err) {
    exit($err); 
} else { 
 exit($response);
}
?>

   