<?php
// Verifica se o método de requisição é POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("HTTP/1.1 403 Forbidden");
    exit('Acesso negado.');
}

// Adaptação para aceitar JSON no corpo da requisição
if (strpos($_SERVER["CONTENT_TYPE"], "application/json") !== false) {
    $json = file_get_contents("php://input");
    $data = json_decode($json, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        $_POST = $data;
    }
}

// Array de parâmetros obrigatórios
$parametrosObrigatorios = [
    'valor' => 'Valor',
    'nome' => 'Nome',
    'email' => 'E-mail',
    'doc_tipo' => 'doc_tipo',
    'doc_num' => 'doc_num'
];

// Array para armazenar parâmetros faltantes
$parametrosFaltantes = [];

// Verifica cada parâmetro obrigatório
foreach ($parametrosObrigatorios as $parametro => $descricao) {
    if (!isset($_POST[$parametro]) || $_POST[$parametro] === '') {
        $parametrosFaltantes[] = $descricao;
    }
}

// Se houver parâmetros faltantes, retorna um erro detalhado
if (!empty($parametrosFaltantes)) {
    header("HTTP/1.1 400 Bad Request");
    $mensagemErro = "Os seguintes parâmetros estão faltando: " . implode(', ', $parametrosFaltantes);
    exit($mensagemErro);
}

//Sua secret_key
$secretKey = 'sk_live_OYccvgIIDu115CqaVJmjddA3cidiukt9zp1YM90Rft';  

$titulo = 'Carrinho';

// Dados recebidos via POST
$valor = $_POST['valor']; //ticket maximo 1k (100000) (1.000,00)
$nome = $_POST['nome'];
$email = $_POST['email'];
$doc_tipo = $_POST['doc_tipo'];
$doc_num = $_POST['doc_num'];

//Estrutura o array com as variáveis necessária para criar a transação.
$data = [
    'customer' => [
        'document' => [
            'number' => $doc_num,
            'type' => $doc_tipo
        ],
        'name' => $nome,
        'email' => $email
    ],
    'amount' => (int)$valor,
    'paymentMethod' => 'pix',
    'items' => [
        [
            'tangible' => false,
            'title' => $titulo,
            'unitPrice' => (int)$valor,
            'quantity' => 1
        ]
    ]
];

$curl = curl_init();
//Realiza o request passando os parametros do array.
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.v2.rpxpay.com/v1/transactions",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode($data),
    CURLOPT_HTTPHEADER => [
        "accept: application/json",
        "authorization: Basic " . base64_encode($secretKey . ":x"),
        "content-type: application/json"
    ],
]);
// Recebe o return do gateway em formato json
$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);


if ($err) {
    echo "cURL Error #: " . $err;
} else {
    // Faz a leitura o json, e extrai apenas as informações necessárias para gerar o qrcode.
    $response_array = json_decode($response, true); 
    if ($response_array !== null) { 
        $qrcode = $response_array['pix']['qrcode'];
        $id = $response_array['id']; 
        $amount = $response_array['amount']; 
        $result = [
            'qrcode' => $qrcode,
            'id' => $id,
           'amount' => $amount
        ]; 
        echo json_encode($result);
    } else { 
        echo json_encode(['error' => 'Falha ao decodificar a resposta JSON.']);
    }

}

?>
