<?php

// Verifica se há parâmetros na URL
if (isset($_SERVER['QUERY_STRING']) && !empty($_SERVER['QUERY_STRING'])) {
  // Captura tudo após o '?' na URL
  $utm_data = $_SERVER['QUERY_STRING'];
  
  // Caminho do arquivo txt onde os dados serão armazenados
  $file_path = 'utm_data.txt';

  // Abre o arquivo para escrever os dados, cria o arquivo se não existir
  $file = fopen($file_path, 'a'); // 'a' para adicionar no final do arquivo
  if ($file) {
    // Escreve os dados no arquivo
    fwrite($file, date('Y-m-d H:i:s') . " | " . $utm_data . "\n");
    fclose($file);
  }
}

function getParametroURL($nomeParametro) {
    if (isset($_GET[$nomeParametro])) {
        return htmlspecialchars($_GET[$nomeParametro], ENT_QUOTES, 'UTF-8');
    } else {
        return null;
    }
}

// Capturar parâmetros UTM de forma segura
$utmSource = getParametroURL('utm_source');
$utmCampaign = getParametroURL('utm_campaign');
$utmMedium = getParametroURL('utm_medium');
$utmContent = getParametroURL('utm_content');
$utmTerm = getParametroURL('utm_term');
$src = getParametroURL('src');

// Definir valores no LocalStorage de forma segura
$utmScriptData = "
    localStorage.setItem('utmSource', " . json_encode($utmSource) . ");
    localStorage.setItem('utmCampaign', " . json_encode($utmCampaign) . ");
    localStorage.setItem('utmMedium', " . json_encode($utmMedium) . ");
    localStorage.setItem('utmContent', " . json_encode($utmContent) . ");
    localStorage.setItem('utmTerm', " . json_encode($utmTerm) . ");
    localStorage.setItem('src', " . json_encode($src) . ");
";
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pagamento PIX</title>
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700;900&display=swap">
    <script src="https://cdn.jsdelivr.net/npm/@tailwindcss/browser@4"></script>
    <link href="https://fonts.cdnfonts.com/css/montserrat" rel="stylesheet">

    <!-- Meta Pixel Code -->
    <script>
    !function(f,b,e,v,n,t,s)
    {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};
    if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
    n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];
    s.parentNode.insertBefore(t,s)}(window, document,'script',
    'https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '806911238441130');
    fbq('track', 'PageView');
    </script>
    <noscript><img height="1" width="1" style="display:none"
    src="https://www.facebook.com/tr?id=806911238441130&ev=PageView&noscript=1"
    /></noscript>
    <!-- End Meta Pixel Code -->

    <!-- Script para salvar parâmetros UTM -->
    <script>
    <?php echo $utmScriptData; ?>
    </script>
    
    <!-- protecoes anti copia -->
    <script src="/protecao.js"></script>
    
    <script type="text/javascript">
        (function(c,l,a,r,i,t,y){
            c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
            t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
            y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
        })(window, document, "clarity", "script", "t8qj9xse8q");
    </script>

    <style>
        /* Base Styles */
        html, body {
            font-family: "Montserrat", sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f7f9;
        }
        
        /* Header Styles */
        header {
            width: 100%;
            height: 60px;
            display: flex;
            align-items: center;
            padding: 0 16px;
            background-color: #fff;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        
        .logo img {
            width: 72px;
            height: auto;
        }
        
        /* Container Styles */
        .content-container {
            max-width: 640px;
            margin: 20px auto;
            padding: 0 16px;
        }
        
        /* Card Styles */
        .card {
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
            overflow: hidden;
            margin-bottom: 16px;
            padding: 16px;
        }
        
        /* Timer Styles */
        .timer {
            color: #e83e8c;
            font-weight: bold;
        }
        
        /* Button Styles */
        .btn-primary {
            background-color: #1FBB70;
            color: white;
            font-weight: bold;
            padding: 12px 16px;
            border-radius: 6px;
            border: none;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .btn-primary:hover {
            background-color: #1aa864;
        }
        
        .btn-primary:disabled {
            background-color: #d3d3d3;
            cursor: not-allowed;
        }
        
        /* Step Icon */
        .step-icon {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            background-color: #FE017B;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .step-icon img {
            width: 24px;
            height: 24px;
            filter: brightness(0) invert(1);
        }
        
        /* Footer Styles */
        footer {
            background-color: #071d41;
            padding: 20px 0;
            margin-top: 40px;
        }
        
        .footer-logo {
            width: 200px;
            padding: 12px;
            margin: 20px auto 0;
            display: block;
        }
        
        footer .copy {
            display: block;
            padding: 20px 12px;
            background-color: #04132a;
            color: #fff;
            font-size: 14px;
            text-align: center;
        }
        
        /* Notification */
        .notification {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: rgba(0, 0, 0, 0.85);
            color: #fff;
            padding: 16px 24px;
            border-radius: 8px;
            z-index: 1000;
            display: none;
            text-align: center;
            max-width: 90%;
        }
    </style>
</head>
<body>
    <header>
        <div class="logo">
            <img src="images/logo.png" alt="Logo">
        </div>
    </header>

    <main class="content-container">
        <div class="card mb-4">
            <h1 class="text-lg font-bold text-center mb-4">Falta pouco! Para finalizar a compra, efetue o pagamento com PIX!</h1>
            <p class="text-center">
                O código expira em: <span id="timer" class="timer">10:00</span>
            </p>
            <hr class="border-t my-4">
            <p class="text-sm text-center mb-4">Copie a chave abaixo e utilize a <br> opção <span class="font-bold">PIX Copia e Cola:</span></p>
            <input id="key_pix_digitable_line1" type="text" class="w-full p-2 border border-gray-300 rounded-md text-center text-sm bg-gray-100 cursor-not-allowed mb-4" value="Aguarde, gerando Pix..." readonly>
            <input id="key_pix_digitable_line2" type="hidden" value="Aguarde, gerando Pix...">
            <button disabled type="button" onclick="copiarCodigo()" id="copy_digitable_line" class="btn-primary">
                <img src="images/svgs/copy.svg" alt="Copiar" class="mr-2"> COPIAR CÓDIGO
            </button>
        </div>
        
        <div class="card">
            <p class="text-lg font-semibold text-center">Valor a ser pago: <span id="valor-total-pagamento" class="text-lg font-bold text-[#FE017B]">R$ 0,00</span></p>
            
            <hr class="border-t my-4">
            
            <div>
                <h2 class="text-lg font-semibold mb-4">Instruções para pagamento</h2>
                
                <div class="flex items-center my-3">
                    <div class="step-icon mr-3">
                        <img src="images/svgs/copyIcon.png" alt="Copiar">
                    </div>
                    <p class="text-sm">Copie o código do Pix.</p>
                </div>
                
                <div class="flex items-center my-3">
                    <div class="step-icon mr-3">
                        <img src="images/svgs/app-indicator.svg" alt="App">
                    </div>
                    <p class="text-sm">Abra o app de pagamento onde você utiliza o Pix.</p>
                </div>
                
                <div class="flex items-center my-3">
                    <div class="step-icon mr-3">
                        <img src="images/svgs/qr-code.svg" alt="QR Code">
                    </div>
                    <p class="text-sm">Escolha <span class="font-bold">PIX Copia e Cola</span> e insira o código copiado.</p>
                </div>
                
                <div class="flex items-center my-3">
                    <div class="step-icon mr-3">
                        <img src="images/svgs/check-circle-line-white.svg" alt="Check">
                    </div>
                    <p class="text-sm">Confirme as informações e finalize sua compra.</p>
                </div>
            </div>
        </div>
        
        <div class="flex justify-center items-center mt-6">
            <img src="images/svgs/soon-pix.svg" alt="Pix em breve" class="w-20">
            <div class="mx-4 h-px bg-gray-300 w-12"></div>
            <img src="images/svgs/safe-environment.svg" alt="Ambiente seguro" class="w-20">
        </div>
    </main>

    <div id="notification" class="notification"></div>

    <footer>
        <img src="images/logo.png" alt="Logo" class="footer-logo">
        <div class="copy">
            © <?php echo date('Y'); ?> - Todos os direitos reservados
        </div>
    </footer>


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="js/checkout.js"></script>
</body>
</html>