<?php 

// Verifica se o método de requisição é POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("HTTP/1.1 403 Forbidden");
    exit('Acesso negado.');
}

// Adaptação para aceitar JSON no corpo da requisição
if (strpos($_SERVER["CONTENT_TYPE"], "application/json") !== false) {
    $json = file_get_contents("php://input");
    $data = json_decode($json, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        $_POST = $data;
    }
}

// Array de parâmetros obrigatórios
$parametrosObrigatorios = [
    'transactionId' => 'Id Transacao'
];

// Array para armazenar parâmetros faltantes
$parametrosFaltantes = [];

// Verifica cada parâmetro obrigatório
foreach ($parametrosObrigatorios as $parametro => $descricao) {
    if (!isset($_POST[$parametro]) || $_POST[$parametro] === '') {
        $parametrosFaltantes[] = $descricao;
    }
}

// Se houver parâmetros faltantes, retorna um erro detalhado
if (!empty($parametrosFaltantes)) {
    header("HTTP/1.1 400 Bad Request");
    $mensagemErro = "Os seguintes parâmetros estão faltando: " . implode(', ', $parametrosFaltantes);
    exit($mensagemErro);
}

// Sua chave de autorização
$authKey = '3731b670-3dce-4b36-89f3-75711963c354';

// Recebe o ID da transação via POST
$transactionId = $_POST['transactionId'];

$curl = curl_init();

// Realiza o request para consultar o status da transação
curl_setopt_array($curl, [
    CURLOPT_URL => "https://app.ghostspaysv1.com/api/v1/transaction.getPayment?id=" . urlencode($transactionId),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => [
        "Authorization: " . $authKey
    ],
]);

// Recebe a resposta da API
$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

if ($err) {
    echo json_encode([
        'error' => true,
        'message' => 'Erro na requisição: ' . $err
    ]);
} else {
    // Decodifica a resposta JSON
    $responseData = json_decode($response, true);
    
    if ($responseData === null) {
        echo json_encode([
            'error' => true,
            'message' => 'Erro ao decodificar resposta JSON'
        ]);
        exit;
    }
    
    echo json_encode($responseData);
}
?>