<?php 

// Verifica se o método de requisição é POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("HTTP/1.1 403 Forbidden");
    exit('Acesso negado.');
}

// Suporte a JSON no corpo da requisição
if (strpos($_SERVER["CONTENT_TYPE"], "application/json") !== false) {
    $json = file_get_contents("php://input");
    $data = json_decode($json, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        $_POST = $data;
    }
}

// Parâmetros obrigatórios
$parametrosObrigatorios = [
    'id_transacao' => 'Id Transacao'
];

$parametrosFaltantes = [];

foreach ($parametrosObrigatorios as $parametro => $descricao) {
    if (!isset($_POST[$parametro]) || $_POST[$parametro] === '') {
        $parametrosFaltantes[] = $descricao;
    }
}

if (!empty($parametrosFaltantes)) {
    header("HTTP/1.1 400 Bad Request");
    $mensagemErro = "Os seguintes parâmetros estão faltando: " . implode(', ', $parametrosFaltantes);
    exit($mensagemErro);
}

// ID da transação recebido via POST
$id_transacao = $_POST['id_transacao'];

// Endpoint da nova API
$url = "https://api-gateway.umbrellapag.com/api/user/transactions/$id_transacao";

// Headers da nova API
$headers = [
    "x-api-key: d5c01451-704e-4a8c-9dbf-d8daba10f237",
    "User-Agent: UMBRELLAB2B/1.0",
    "Accept: application/json"
];

// Inicializa cURL
$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => $headers,
    CURLOPT_TIMEOUT => 30,
]);

$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

// Tratamento de erro
if ($err) {
    header("HTTP/1.1 500 Internal Server Error");
    exit("Erro ao consultar a API: $err");
}

// Retorna o JSON da resposta da API
header("Content-Type: application/json");
exit($response);
?>
