<?php
// utm_bootstrap.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Quais parâmetros queremos capturar
$UTM_KEYS = [
    'utm_source',
    'utm_medium',
    'utm_campaign',
    'utm_content',
    'utm_term',
    'utm_id',
    'src',      // se o cliente usar
    'fbclid',
    'gclid',
];

// Garante array na sessão
if (!isset($_SESSION['utm'])) {
    $_SESSION['utm'] = [];
}

// Se veio UTM na URL, atualiza sessão
$hasUtm = false;
foreach ($UTM_KEYS as $key) {
    if (!empty($_GET[$key])) {
        $_SESSION['utm'][$key] = $_GET[$key];
        $hasUtm = true;
    }
}

// (Opcional) Log em arquivo para auditoria
if ($hasUtm) {
    $logLine = date('Y-m-d H:i:s') . ' | ' . http_build_query($_SESSION['utm']) . PHP_EOL;
    @file_put_contents(__DIR__ . '/utm_data.txt', $logLine, FILE_APPEND);
}

// Helper: monta query string das UTMs que temos na sessão
function utm_build_query($withQuestionMark = true)
{
    if (empty($_SESSION['utm']) || !is_array($_SESSION['utm'])) {
        return '';
    }
    $q = http_build_query($_SESSION['utm']);
    return $withQuestionMark ? ('?' . $q) : $q;
}

// Helper: adiciona UTM numa URL que já tem parâmetros
function utm_append_to_url($url)
{
    if (empty($_SESSION['utm']) || !is_array($_SESSION['utm'])) {
        return $url;
    }

    $separator = (strpos($url, '?') === false) ? '?' : '&';
    return $url . $separator . http_build_query($_SESSION['utm']);
}