<?php
// Verifica se o método de requisição é POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("HTTP/1.1 403 Forbidden");
    exit('Acesso negado.');
}

// Suporte a JSON no corpo da requisição
if (strpos($_SERVER["CONTENT_TYPE"], "application/json") !== false) {
    $json = file_get_contents("php://input");
    $data = json_decode($json, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        $_POST = $data;
    }
}

// Parâmetros obrigatórios
$parametrosObrigatorios = [
    'valor' => 'Valor',
    'nome' => 'Nome',
    'email' => 'E-mail',
    'doc_num' => 'Documento (CPF)'
];

$parametrosFaltantes = [];
foreach ($parametrosObrigatorios as $parametro => $descricao) {
    if (!isset($_POST[$parametro]) || $_POST[$parametro] === '') {
        $parametrosFaltantes[] = $descricao;
    }
}

// Retorna erro se houver parâmetros faltantes
if (!empty($parametrosFaltantes)) {
    header("HTTP/1.1 400 Bad Request");
    $mensagemErro = "Os seguintes parâmetros estão faltando: " . implode(', ', $parametrosFaltantes);
    exit($mensagemErro);
}

// Dados POST
$valor = (int)$_POST['valor'];
$nome = $_POST['nome'];
$email = $_POST['email'];
$doc_num = $_POST['doc_num'];

// Monta payload para a nova API
$data = [
    "amount" => $valor,
    "currency" => "BRL",
    "paymentMethod" => "PIX",
    "installments" => 0,
    "customer" => [
        "name" => $nome,
        "email" => $email,
        "document" => [
            "number" => $doc_num,
            "type" => "CPF"
        ],
        "phone" => "11999999999", // fixo
        "externalRef" => "string" // fixo
    ],
    "items" => [
        [
            "title" => "CART",
            "unitPrice" => $valor,
            "tangible" => true,
            "quantity" => 1
        ]
    ],
    "boleto" => [
        "expiresInDays" => 0
    ],
    "pix" => [
        "expiresInDays" => 0
    ],
    "postbackUrl" => "string",
    "metadata" => "no",
    "traceable" => true,
    "ip" => "127.0.0.1"
];

// Inicia cURL para chamada da nova API
$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => "https://api-gateway.umbrellapag.com/api/user/transactions",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode($data),
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json",
        "x-api-key: d5c01451-704e-4a8c-9dbf-d8daba10f237",
        "User-Agent: UMBRELLAB2B/1.0"
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

// Processa a resposta
if ($err) {
    echo json_encode(["error" => "Erro de comunicação: $err"]);
} else {
    $response_array = json_decode($response, true);

    if ($response_array !== null) {
        // Verifica se o qrcode existe na estrutura correta
        if (isset($response_array['data']['pix']['qrcode']) && !empty($response_array['data']['pix']['qrcode'])) {
            echo json_encode([
                'qrcode' => $response_array['data']['pix']['qrcode'],
                'id' => $response_array['data']['id'] ?? null,
                'amount' => $response_array['data']['amount'] ?? null,
                'status' => $response_array['data']['status'] ?? null
            ]);
        } else {
            // Se não encontrar o qrcode, retorna toda a resposta da API para debug
            echo json_encode([
                'error' => 'QRCODE não encontrado na resposta.',
                'resposta_api' => $response_array
            ]);
        }
    } else {
        echo json_encode(["error" => "Falha ao decodificar JSON da resposta."]);
    }
}
?>