<?php
require 'PixPayment.php';

// Este arquivo processa o pedido de Pix Gerado.

// URL da API e token da API
$apiUrl = "https://api.utmify.com.br/api-credentials/orders";
$apiToken = "Q9wleXlhc99UqI9Lt56DyoGEhpjybyiFqACo";

// Função para registrar erros
function logProcessorError($message, $data = []) {
    $logFileName = 'LOG-' . date('Y-m-d_H-i-s') . '_ERRO_PROCESSADOR_PIX.txt';
    $logContent = "[" . date('Y-m-d H:i:s') . "] " . $message . "\n";
    
    if (!empty($data)) {
        $logContent .= "Dados: " . json_encode($data, JSON_PRETTY_PRINT) . "\n";
    }
    
    try {
        file_put_contents($logFileName, $logContent, FILE_APPEND);
        return true;
    } catch (Exception $e) {
        error_log("Erro ao escrever no arquivo de log: " . $e->getMessage());
        return false;
    }
}

// Função para salvar os dados do POST em um arquivo
function savePostData($postData) {
    // Gera um ID único para o arquivo baseado no timestamp
    $uniqueId = time() . '_' . mt_rand(1000, 9999);
    
    // Cria o nome do arquivo
    $fileName = 'POST_DATA_' . $uniqueId . '_' . date('Y-m-d_H-i-s') . '.txt';
    
    // Formata o conteúdo do arquivo
    $fileContent = "DADOS DO POST RECEBIDO\n";
    $fileContent .= "Data: " . date('Y-m-d H:i:s') . "\n";
    $fileContent .= "ID: " . $uniqueId . "\n";
    $fileContent .= "-----------------------------------\n";
    $fileContent .= json_encode($postData, JSON_PRETTY_PRINT);
    
    // Tenta escrever no arquivo
    try {
        file_put_contents($fileName, $fileContent);
        return true;
    } catch (Exception $e) {
        logProcessorError("Erro ao salvar dados do POST em arquivo", [
            'uniqueId' => $uniqueId,
            'erro' => $e->getMessage()
        ]);
        return false;
    }
}

try {
    // Instancia a classe PixPayment
    $pixPayment = new PixPayment($apiUrl, $apiToken);

    // Recebe os dados enviados pelo AJAX
    $rawInput = file_get_contents('php://input');
    $postData = json_decode($rawInput, true);

    // Verifica se o JSON foi decodificado corretamente
    if (json_last_error() !== JSON_ERROR_NONE) {
        $errorMessage = "Erro ao decodificar JSON: " . json_last_error_msg();
        logProcessorError($errorMessage, ['input' => $rawInput]);
        
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'error',
            'message' => $errorMessage,
            'error_code' => 400
        ]);
        exit;
    }
    
    // Salva os dados recebidos no POST
    savePostData($postData);

    $status = $_GET['status'] ?? 'waiting_payment'; // Se não vier, default 'waiting_payment'

    // Verifica campos obrigatórios
    $requiredFields = ['name', 'email', 'phone', 'document', 'trackingParameters'];
    $missingFields = [];
    
    foreach ($requiredFields as $field) {
        if (empty($postData[$field])) {
            $missingFields[] = $field;
        }
    }

    if (!empty($missingFields)) {
        $errorMessage = "Campos obrigatórios ausentes: " . implode(', ', $missingFields);
        logProcessorError($errorMessage, ['postData' => $postData]);
        
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'error',
            'message' => $errorMessage,
            'missing_fields' => $missingFields,
            'error_code' => 400
        ]);
        exit;
    }
    
    // Verifica carrinho
    if (!isset($postData['cart']) || !isset($postData['cart']['itens']) || empty($postData['cart']['itens'])) {
        $warningMessage = "Carrinho ausente ou vazio";
        logProcessorError($warningMessage, ['postData' => $postData]);
        
        // Decide se continua sem carrinho ou retorna erro
        // Aqui optamos por retornar erro
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'error',
            'message' => $warningMessage,
            'error_code' => 400
        ]);
        exit;
    }

    // Tudo ok, processa o pagamento
    $response = $pixPayment->sendPix($postData, $status);
    
    // Verifica se a resposta foi bem-sucedida
    $isSuccess = ($response['status_code'] >= 200 && $response['status_code'] < 300);
    
    // Retorna a resposta como JSON
    header('Content-Type: application/json');
    echo json_encode([
        'status' => $isSuccess ? 'success' : 'error',
        'data' => json_decode($response['response'], true),
        'http_code' => $response['status_code']
    ]);

} catch (Exception $e) {
    // Log de exceção
    $errorMessage = "Exceção no processamento: " . $e->getMessage();
    logProcessorError($errorMessage, [
        'trace' => $e->getTraceAsString(),
        'postData' => $postData ?? null
    ]);
    
    // Retorna erro
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'Erro interno ao processar pagamento',
        'error_code' => 500
    ]);
}