function atualizarStepper(etapaAtual) {
  // Elementos do stepper
  const stepperCircles = document.querySelectorAll(
    "#stepper .flex.flex-col.items-center"
  );

  if (stepperCircles.length >= 3) {
    const identificacaoCircle = stepperCircles[0];
    const entregaCircle = stepperCircles[1];
    const pagamentoCircle = stepperCircles[2];

    // Reset de todas as etapas
    [identificacaoCircle, entregaCircle, pagamentoCircle].forEach((circle) => {
      // Reset do círculo
      const circleElement = circle.querySelector("div:first-child");
      if (circleElement) {
        circleElement.className =
          "flex items-center justify-center w-8 h-8 bg-gray-200 text-gray-500 rounded-full";
      }

      // Reset do texto
      const textElement = circle.querySelector("div:nth-child(2)");
      if (textElement) {
        textElement.className = "mt-2 text-base font-base text-gray-500";
      }

      // Esconder check e mostrar número
      const checkElement = circleElement.querySelector(".check");
      const numberElement = circleElement.querySelector(":not(.check)");

      if (checkElement) checkElement.style.display = "none";
      if (numberElement && !numberElement.classList.contains("check"))
        numberElement.style.display = "inline";
    });

    // Atualiza conforme a etapa atual
    if (etapaAtual === "identificacao") {
      // Identificação ativa
      const circleElement =
        identificacaoCircle.querySelector("div:first-child");
      const textElement = identificacaoCircle.querySelector("div:nth-child(2)");

      if (circleElement)
        circleElement.className =
          "flex items-center justify-center w-8 h-8 bg-[#FE017B] text-white rounded-full";
      if (textElement)
        textElement.className = "mt-2 text-base font-semibold text-gray-700";
    } else if (etapaAtual === "entrega") {
      // Identificação completa com check
      const identificacaoCircle = stepperCircles[0];
      const identificacaoCircleElement =
        identificacaoCircle.querySelector("div:first-child");
      const identificacaoTextElement =
        identificacaoCircle.querySelector("div:nth-child(2)");

      if (identificacaoCircleElement) {
        identificacaoCircleElement.className =
          "flex items-center justify-center w-8 h-8 bg-[#FE017B] text-white rounded-full";

        // Mostrar check e esconder número
        const checkElement = identificacaoCircleElement.querySelector(".check");
        const numberElement =
          identificacaoCircleElement.querySelector(":not(.check)");

        if (checkElement) checkElement.style.display = "inline";
        if (numberElement && !numberElement.classList.contains("check"))
          numberElement.style.display = "none";
      }
      if (identificacaoTextElement)
        identificacaoTextElement.className =
          "mt-2 text-base font-semibold text-gray-700";

      // Entrega ativa
      const entregaCircleElement =
        entregaCircle.querySelector("div:first-child");
      const entregaTextElement =
        entregaCircle.querySelector("div:nth-child(2)");

      if (entregaCircleElement)
        entregaCircleElement.className =
          "flex items-center justify-center w-8 h-8 bg-[#FE017B] text-white rounded-full";
      if (entregaTextElement)
        entregaTextElement.className =
          "mt-2 text-base font-semibold text-gray-700";
    } else if (etapaAtual === "pagamento") {
      // Identificação e entrega completas com check
      [identificacaoCircle, entregaCircle].forEach((circle) => {
        const circleElement = circle.querySelector("div:first-child");
        const textElement = circle.querySelector("div:nth-child(2)");

        if (circleElement) {
          circleElement.className =
            "flex items-center justify-center w-8 h-8 bg-[#FE017B] text-white rounded-full";

          // Mostrar check e esconder número
          const checkElement = circleElement.querySelector(".check");
          const numberElement = circleElement.querySelector(":not(.check)");

          if (checkElement) checkElement.style.display = "inline";
          if (numberElement && !numberElement.classList.contains("check"))
            numberElement.style.display = "none";
        }
        if (textElement)
          textElement.className = "mt-2 text-base font-semibold text-gray-700";
      });

      // Pagamento ativo
      const pagamentoCircleElement =
        pagamentoCircle.querySelector("div:first-child");
      const pagamentoTextElement =
        pagamentoCircle.querySelector("div:nth-child(2)");

      if (pagamentoCircleElement)
        pagamentoCircleElement.className =
          "flex items-center justify-center w-8 h-8 bg-[#FE017B] text-white rounded-full";
      if (pagamentoTextElement)
        pagamentoTextElement.className =
          "mt-2 text-base font-semibold text-gray-700";
    }
  }
}
