<?php
// Verifica se o método de requisição é POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("HTTP/1.1 403 Forbidden");
    exit('Acesso negado.');
}

// Adaptação para aceitar JSON no corpo da requisição
if (strpos($_SERVER["CONTENT_TYPE"], "application/json") !== false) {
    $json = file_get_contents("php://input");
    $data = json_decode($json, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        $_POST = $data;
    }
}

// Array de parâmetros obrigatórios
$parametrosObrigatorios = [
    'valor' => 'Valor',
    'nome' => 'Nome',
    'email' => 'E-mail',
    'cpf' => 'CPF',
    'telefone' => 'Telefone'
];

// Array para armazenar parâmetros faltantes
$parametrosFaltantes = [];

// Verifica cada parâmetro obrigatório
foreach ($parametrosObrigatorios as $parametro => $descricao) {
    if (!isset($_POST[$parametro]) || $_POST[$parametro] === '') {
        $parametrosFaltantes[] = $descricao;
    }
}

// Se houver parâmetros faltantes, retorna um erro detalhado
if (!empty($parametrosFaltantes)) {
    header("HTTP/1.1 400 Bad Request");
    $mensagemErro = "Os seguintes parâmetros estão faltando: " . implode(', ', $parametrosFaltantes);
    exit($mensagemErro);
}

// Sua chave de autorização
$authKey = '3731b670-3dce-4b36-89f3-75711963c354';

$titulo = 'Carrinho';

// Dados recebidos via POST
$valor = $_POST['valor']; //ticket maximo 1k (100000) (1.000,00)
$nome = $_POST['nome'];
$email = $_POST['email'];
$cpf = $_POST['cpf'];
$telefone = $_POST['telefone'];

// Estrutura o array com as variáveis necessárias para criar a transação
$data = [
    'name' => $nome,
    'email' => $email,
    'cpf' => $cpf,
    'phone' => $telefone,
    'paymentMethod' => 'PIX',
    'amount' => (int)$valor,
    'traceable' => true,
    'items' => [
        [
            'tangible' => false,
            'title' => $titulo,
            'unitPrice' => (int)$valor,
            'quantity' => 1
        ]
    ]
];

$curl = curl_init();

// Realiza o request passando os parâmetros do array
curl_setopt_array($curl, [
    CURLOPT_URL => "https://app.ghostspaysv1.com/api/v1/transaction.purchase",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode($data),
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json",
        "Authorization: " . $authKey
    ],
]);

// Recebe o retorno da API em formato json
$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

if ($err) {
    echo "cURL Error #: " . $err;
} else {
    // Faz a leitura do json e extrai as informações necessárias
    $response_array = json_decode($response, true);
    if ($response_array !== null) {

        echo json_encode($response_array);
    } else {
        echo json_encode([
            'error' => 'Falha ao decodificar a resposta JSON.',
            'status' => 'ERROR'
        ]);
    }
}

?>